/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.content.items;

import euphy.upo.createnetherindustry.entity.LavaSpeedboatEntity;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LavaSpeedboatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = ((Predicate<Entity>)entity -> !entity.isSpectator()).and(Entity::isPickable);

    public LavaSpeedboatItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        BlockHitResult hitResult = LavaSpeedboatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        Vec3 lookAngle = player.getViewVector(1.0f);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(lookAngle.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 eyePosition = player.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(eyePosition)) continue;
                return InteractionResultHolder.pass((Object)itemStack);
            }
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            LavaSpeedboatEntity speedboat = new LavaSpeedboatEntity(level, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z);
            speedboat.setYRot(player.getYRot());
            if (!level.noCollision((Entity)speedboat, speedboat.getBoundingBox())) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)speedboat);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitResult.getLocation());
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }
}

