/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.content.kinetics.fan.soul_stripping;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import euphy.upo.createnetherindustry.registry.CNIRecipes;
import euphy.upo.createnetherindustry.registry.CNITags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SoulStrippingFanProcessingType
implements FanProcessingType {
    public boolean isValidAt(Level level, BlockPos pos) {
        return level.getBlockState(pos).is(CNITags.FAN_SOUL_STRIPPING_CATALYSTS);
    }

    public int getPriority() {
        return 450;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return false;
        }
        return level.getRecipeManager().getRecipeFor(CNIRecipes.SOUL_STRIPPING_TYPE_INFO.getType(), (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return null;
        }
        return level.getRecipeManager().getRecipeFor(CNIRecipes.SOUL_STRIPPING_TYPE_INFO.getType(), (RecipeInput)new SingleRecipeInput(stack), level).map(recipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeHolder.value(), (boolean)true)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(5) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.SOUL, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.8f), pos.y + (double)0.2f + (double)(level.random.nextFloat() * 0.5f), pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.8f), (double)((level.random.nextFloat() - 0.5f) * 0.01f), (double)(level.random.nextFloat() * 0.05f), (double)((level.random.nextFloat() - 0.5f) * 0.01f));
        }
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        if (random.nextBoolean()) {
            particleAccess.setColor(11393254);
        } else {
            particleAccess.setColor(0xAFEEEE);
        }
        particleAccess.setAlpha(0.8f + random.nextFloat() * 0.2f);
        if (random.nextInt(16) == 0) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, 0.05f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.getType().is(EntityTypeTags.UNDEAD)) {
                if (livingEntity.tickCount % 20 == 0) {
                    livingEntity.heal(1.0f);
                }
            } else {
                DamageSources damageSources = level.damageSources();
                if (livingEntity.tickCount % 20 == 0) {
                    livingEntity.hurt(damageSources.magic(), 1.0f);
                }
            }
        }
    }
}

