/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.entity;

import euphy.upo.createnetherindustry.registry.CNIEntities;
import euphy.upo.createnetherindustry.registry.CNIItems;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LavaSpeedboatEntity
extends Boat {
    private final Random random = new Random();

    public LavaSpeedboatEntity(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
    }

    public LavaSpeedboatEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)CNIEntities.LAVA_SPEEDBOAT.get()), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.getDeltaMovement().lengthSqr() > 0.01) {
            Vec3 forward = this.getLookAngle().scale(-0.7);
            double x = this.getX() + forward.x;
            double y = this.getY() + 0.4;
            double z = this.getZ() + forward.z;
            for (int i = 0; i < 2; ++i) {
                double offsetX = (this.random.nextDouble() - 0.5) * 0.3;
                double offsetY = (this.random.nextDouble() - 0.5) * 0.3;
                double offsetZ = (this.random.nextDouble() - 0.5) * 0.3;
                this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.05, 0.0);
            }
        }
    }

    public static LavaSpeedboatEntity create(EntityType<? extends Boat> type, Level level) {
        return new LavaSpeedboatEntity(type, level);
    }

    public boolean canBoatInFluid(@NotNull FluidState fluidState) {
        return fluidState.is(FluidTags.LAVA);
    }

    @NotNull
    public Item getDropItem() {
        return (Item)CNIItems.LAVA_SPEEDBOAT.get();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected boolean canAddPassenger(@NotNull Entity passenger) {
        return this.getPassengers().isEmpty();
    }

    public int getMaxPassengers() {
        return 1;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTicks) {
        double x = 0.0;
        double y = (double)dimensions.height() * 1.5;
        double z = 0.0;
        return new Vec3(x, y, z);
    }
}

