/*
 * Decompiled with CFR 0.152.
 */
package euphy.upo.createnetherindustry.event;

import euphy.upo.createnetherindustry.content.blocks.corp.BlazeCropBlock;
import euphy.upo.createnetherindustry.registry.CNIBlocks;
import euphy.upo.createnetherindustry.registry.CNIItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class BlazeTwigPlantingHandler {
    @SubscribeEvent
    public static void onPlayerRightClickBlockPlantBlazeTwig(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Level level = event.getLevel();
        BlockPos clickedPos = event.getPos();
        Player player = event.getEntity();
        ItemStack heldStack = event.getItemStack();
        InteractionHand hand = event.getHand();
        if (heldStack.getItem() != CNIItems.BLAZE_TWIG.get()) {
            return;
        }
        BlockState clickedBlockState = level.getBlockState(clickedPos);
        if (!clickedBlockState.is(CNIBlocks.CRIMSON_NYLIUM_FARMLAND)) {
            return;
        }
        BlockPos plantPos = clickedPos.above();
        if (!level.getBlockState(plantPos).isAir()) {
            return;
        }
        BlockState cropToPlace = ((BlazeCropBlock)((Object)CNIBlocks.BLAZE_TWIG_CROP.get())).defaultBlockState();
        if (!cropToPlace.canSurvive((LevelReader)level, plantPos)) {
            return;
        }
        if (!level.isClientSide) {
            level.setBlock(plantPos, cropToPlace, 3);
            BlockState placedCropState = level.getBlockState(plantPos);
            level.playSound(null, plantPos, placedCropState.getSoundType((LevelReader)level, plantPos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                heldStack.shrink(1);
            }
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
    }
}

