/*
 * Decompiled with CFR 0.152.
 */
package com.upo.createnetherindustry;

import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.RegistrateDataProvider;
import com.upo.createnetherindustry.client.render.SoulCondenserRenderer;
import com.upo.createnetherindustry.content.recipes.condenser.CondenserRecipeSerializers;
import com.upo.createnetherindustry.content.recipes.condenser.CondenserRecipeType;
import com.upo.createnetherindustry.data.CNIRecipeProvider;
import com.upo.createnetherindustry.data.CNITagsProvider;
import com.upo.createnetherindustry.ponder.CNIPonderPlugin;
import com.upo.createnetherindustry.registry.CNIBlockEntities;
import com.upo.createnetherindustry.registry.CNIBlocks;
import com.upo.createnetherindustry.registry.CNICreativeTabs;
import com.upo.createnetherindustry.registry.CNIFanProcessingTypes;
import com.upo.createnetherindustry.registry.CNIFluids;
import com.upo.createnetherindustry.registry.CNIItems;
import com.upo.createnetherindustry.registry.CNIPartials;
import com.upo.createnetherindustry.registry.CNIRecipes;
import com.upo.createnetherindustry.registry.CNIStress;
import com.upo.createnetherindustry.registry.CNITags;
import java.util.concurrent.CompletableFuture;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="createnetherindustry")
public class CreateNetherIndustry {
    public static final String MODID = "createnetherindustry";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"createnetherindustry").defaultCreativeTab(CNICreativeTabs.MAIN_TAB.getKey());

    public CreateNetherIndustry(IEventBus modEventBus, ModContainer modContainer) {
        REGISTRATE.registerEventListeners(modEventBus);
        CNIItems.register();
        CNIBlocks.register();
        CNIFluids.register();
        CNITags.register();
        CNIRecipes.register(modEventBus);
        CondenserRecipeType.register(modEventBus);
        CondenserRecipeSerializers.register(modEventBus);
        CNIFanProcessingTypes.register(modEventBus);
        CNICreativeTabs.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(CreateNetherIndustry::gatherData);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CNIStress.registerAllStressValues();
            CNIPartials.init();
            CNIFluids.registerFluidInteractions();
        });
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        RegistrateDataProvider registrateDataProvider = new RegistrateDataProvider((AbstractRegistrate)REGISTRATE, MODID, event);
        generator.addProvider(true, (DataProvider)REGISTRATE.setDataProvider(registrateDataProvider));
        CNITagsProvider blockTagProvider = new CNITagsProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new CNIRecipeProvider(packOutput, lookupProvider));
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CNIBlockEntities.SOUL_CONDENSER.get(), (be, context) -> be.getFluidHandlerCapability((Direction)context));
    }

    @EventBusSubscriber(modid="createnetherindustry", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)CNIBlockEntities.SOUL_CONDENSER.get()), SoulCondenserRenderer::new);
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)CNIBlocks.SOUL_STRIPPING_MEDIUM.get()), (RenderType)RenderType.cutoutMipped());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)CNIBlocks.BLAZE_TWIG_CROP.get()), (RenderType)RenderType.cutoutMipped());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)CNIBlocks.WITHER_BUSH_CROP.get()), (RenderType)RenderType.cutoutMipped());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)CNIBlocks.SOUL_CONDENSER.get()), (RenderType)RenderType.cutoutMipped());
                PonderIndex.addPlugin((PonderPlugin)new CNIPonderPlugin());
            });
        }
    }
}

