/*
 * Decompiled with CFR 0.152.
 */
package com.upo.createnetherindustry.compat.jei;

import com.google.common.base.Preconditions;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.upo.createnetherindustry.CreateNetherIndustry;
import com.upo.createnetherindustry.compat.jei.SoulCondensingCategory;
import com.upo.createnetherindustry.compat.jei.SoulStrippingCategory;
import com.upo.createnetherindustry.registry.CNIBlocks;
import com.upo.createnetherindustry.registry.CNIItems;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;

@JeiPlugin
public class CNIJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = CreateNetherIndustry.asResource("jei_plugin");
    private final List<IRecipeCategory<?>> categories = new ArrayList();

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        ArrayList<Object> localCategories = new ArrayList<Object>();
        localCategories.add((Object)SoulStrippingCategory.create(guiHelper));
        localCategories.add((Object)SoulCondensingCategory.create(guiHelper));
        registration.addRecipeCategories(localCategories.toArray(new IRecipeCategory[0]));
        this.categories.clear();
        this.categories.addAll(localCategories);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ItemStack witherRoseItemStack;
        ItemStack goldenCarrotItemStack;
        ItemStack soulBlazeAxeItemStack;
        ItemStack soulBlazePickaxeItemStack;
        ItemStack ancientMechanismItemStack;
        ItemStack blazeTwigItemStack;
        ItemStack mediumItemStack;
        for (IRecipeCategory<?> category : this.categories) {
            if (!(category instanceof CreateRecipeCategory)) continue;
            ((CreateRecipeCategory)category).registerRecipes(registration);
        }
        ItemStack soulItemStack = new ItemStack((ItemLike)CNIItems.SOUL_ITEM.get());
        if (!soulItemStack.isEmpty()) {
            MutableComponent soul_description_alt1 = Component.translatable((String)"jei.createnetherindustry.info.soul_item_alt.line1");
            MutableComponent soul_description_alt2 = Component.translatable((String)"jei.createnetherindustry.info.soul_item_alt.line2");
            registration.addItemStackInfo(soulItemStack, new Component[]{soul_description_alt1, soul_description_alt2});
        }
        if (!(mediumItemStack = new ItemStack((ItemLike)CNIBlocks.SOUL_STRIPPING_MEDIUM.get())).isEmpty()) {
            MutableComponent medium_description_alt1 = Component.translatable((String)"jei.createnetherindustry.info.medium.line1");
            MutableComponent medium_description_alt2 = Component.translatable((String)"jei.createnetherindustry.info.medium.line2");
            registration.addItemStackInfo(mediumItemStack, new Component[]{medium_description_alt1, medium_description_alt2});
        }
        if (!(blazeTwigItemStack = new ItemStack((ItemLike)CNIItems.BLAZE_TWIG.get())).isEmpty()) {
            MutableComponent twig_description_alt1 = Component.translatable((String)"jei.createnetherindustry.info.blaze_twig.line1");
            MutableComponent twig_description_alt2 = Component.translatable((String)"jei.createnetherindustry.info.blaze_twig.line2");
            registration.addItemStackInfo(blazeTwigItemStack, new Component[]{twig_description_alt1, twig_description_alt2});
        }
        if (!(ancientMechanismItemStack = new ItemStack((ItemLike)CNIItems.ANCIENT_MECHANISM.get())).isEmpty()) {
            MutableComponent am_description_alt1 = Component.translatable((String)"jei.createnetherindustry.info.ancient_mechanism.line1");
            MutableComponent am_description_alt2 = Component.translatable((String)"jei.createnetherindustry.info.ancient_mechanism.line2");
            registration.addItemStackInfo(ancientMechanismItemStack, new Component[]{am_description_alt1, am_description_alt2});
        }
        if (!(soulBlazePickaxeItemStack = new ItemStack((ItemLike)CNIItems.SOUL_BLAZE_PICKAXE.get())).isEmpty()) {
            MutableComponent sbp_description_alt1 = Component.translatable((String)"jei.createnetherindustry.info.soul_blaze_pickaxe.line1");
            MutableComponent sbp_description_alt2 = Component.translatable((String)"jei.createnetherindustry.info.soul_blaze_pickaxe.line2");
            registration.addItemStackInfo(soulBlazePickaxeItemStack, new Component[]{sbp_description_alt1, sbp_description_alt2});
        }
        if (!(soulBlazeAxeItemStack = new ItemStack((ItemLike)CNIItems.SOUL_BLAZE_AXE.get())).isEmpty()) {
            MutableComponent sba_description_alt1 = Component.translatable((String)"jei.createnetherindustry.info.soul_blaze_axe.line1");
            MutableComponent sba_description_alt2 = Component.translatable((String)"jei.createnetherindustry.info.soul_blaze_axe.line2");
            registration.addItemStackInfo(soulBlazeAxeItemStack, new Component[]{sba_description_alt1, sba_description_alt2});
        }
        if (!(goldenCarrotItemStack = new ItemStack((ItemLike)Items.GOLDEN_CARROT)).isEmpty()) {
            MutableComponent golden_carrot_description_alt1 = Component.translatable((String)"jei.createnetherindustry.info.golden_carrot.line1");
            MutableComponent golden_carrot_description_alt2 = Component.translatable((String)"jei.createnetherindustry.info.golden_carrot.line2");
            registration.addItemStackInfo(goldenCarrotItemStack, new Component[]{golden_carrot_description_alt1, golden_carrot_description_alt2});
        }
        if (!(witherRoseItemStack = new ItemStack((ItemLike)Items.WITHER_ROSE)).isEmpty()) {
            MutableComponent wither_rose_description_alt1 = Component.translatable((String)"jei.createnetherindustry.info.wither_rose.line1");
            MutableComponent wither_rose_description_alt2 = Component.translatable((String)"jei.createnetherindustry.info.wither_rose.line2");
            registration.addItemStackInfo(witherRoseItemStack, new Component[]{wither_rose_description_alt1, wither_rose_description_alt2});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(AllBlocks.ENCASED_FAN.asStack(), new RecipeType[]{SoulStrippingCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CNIBlocks.SOUL_STRIPPING_MEDIUM.get()), new RecipeType[]{SoulStrippingCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CNIBlocks.SOUL_CONDENSER.get()), new RecipeType[]{SoulCondensingCategory.TYPE});
    }

    public static Level getLevel() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)"Minecraft instance was null");
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)"Client level was null");
        return level;
    }

    public static RecipeManager getRecipeManager() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving recipe manager from client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)"Minecraft instance was null");
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)"Client level was null");
        return level.getRecipeManager();
    }
}

