/*
 * Decompiled with CFR 0.152.
 */
package com.upo.createnetherindustry.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.upo.createnetherindustry.CreateNetherIndustry;
import com.upo.createnetherindustry.compat.jei.CNIJEIPlugin;
import com.upo.createnetherindustry.content.recipes.condenser.CondenserRecipeType;
import com.upo.createnetherindustry.content.recipes.condenser.CondensingRecipe;
import com.upo.createnetherindustry.registry.CNIBlocks;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class SoulCondensingCategory
extends CreateRecipeCategory<CondensingRecipe> {
    public static final RecipeType<CondensingRecipe> TYPE = new RecipeType(CreateNetherIndustry.asResource("soul_condensing"), CondensingRecipe.class);
    private static final int BG_WIDTH = 177;
    private static final int BG_HEIGHT = 80;
    private static final int FLUID_TANK_WIDTH = 16;
    private static final int FLUID_TANK_HEIGHT = 48;

    public SoulCondensingCategory(CreateRecipeCategory.Info<CondensingRecipe> info) {
        super(info);
    }

    public static SoulCondensingCategory create(IGuiHelper guiHelper) {
        Supplier<List> recipesSupplier = () -> CNIJEIPlugin.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)CondenserRecipeType.SOUL_CONDENSING_RECIPE_TYPE_DEFERRED.get()).stream().filter(holder -> holder.value() instanceof CondensingRecipe).map(holder -> new RecipeHolder(holder.id(), (Recipe)((CondensingRecipe)holder.value()))).collect(Collectors.toList());
        Supplier<ItemStack> condenserCatalystSupplier = () -> new ItemStack((ItemLike)CNIBlocks.SOUL_CONDENSER.get());
        List<Supplier<ItemStack>> catalysts = List.of(condenserCatalystSupplier);
        CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(TYPE, (Component)Component.translatable((String)"recipe.createnetherindustry.soul_condensing"), (IDrawable)new EmptyBackground(177, 70), guiHelper.createDrawableItemStack(new ItemStack((ItemLike)CNIBlocks.SOUL_CONDENSER.get())), recipesSupplier, catalysts);
        return new SoulCondensingCategory((CreateRecipeCategory.Info<CondensingRecipe>)info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CondensingRecipe recipe, IFocusGroup focuses) {
        FluidStack inputFluid = recipe.getInputFluid();
        FluidStack outputFluid = recipe.getOutputFluid();
        int fluidVisualCapacity = 200;
        int inputTankX = 16;
        int inputTankY = 17;
        int outputTankX = 147;
        int outputTankY = inputTankY;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, inputTankX, inputTankY).addFluidStack(inputFluid.getFluid(), (long)inputFluid.getAmount())).setFluidRenderer((long)Math.max(fluidVisualCapacity, inputFluid.getAmount()), false, 16, 48);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, outputTankX, outputTankY).addFluidStack(outputFluid.getFluid(), (long)outputFluid.getAmount())).setFluidRenderer((long)Math.max(fluidVisualCapacity, outputFluid.getAmount()), false, 16, 48);
    }

    public void draw(CondensingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int inputTankBgX = 15;
        int inputTankBgY = 16;
        this.drawFluidTankBackground(graphics, inputTankBgX, inputTankBgY);
        int outputTankBgX = 146;
        int outputTankBgY = inputTankBgY;
        this.drawFluidTankBackground(graphics, outputTankBgX, outputTankBgY);
        int arrowX = (177 - AllGuiTextures.JEI_ARROW.getWidth()) / 2;
        int arrowY = (80 - AllGuiTextures.JEI_ARROW.getHeight()) / 2 + 12;
        AllGuiTextures.JEI_ARROW.render(graphics, arrowX, arrowY);
        ItemStack soulCondenserStack = new ItemStack((ItemLike)CNIBlocks.SOUL_CONDENSER.get());
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int itemCenterX = 88;
        int itemCenterY = 30;
        float desiredVisualSize = 32.0f;
        poseStack.translate((float)itemCenterX, (float)itemCenterY, 100.0f);
        poseStack.scale(desiredVisualSize, -desiredVisualSize, desiredVisualSize);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel bakedModel = itemRenderer.getModel(soulCondenserStack, null, null, 0);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        itemRenderer.render(soulCondenserStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        buffer.endBatch();
        poseStack.popPose();
    }

    protected void drawFluidTankBackground(GuiGraphics graphics, int x, int y) {
        int borderWidth = 18;
        int borderHeight = 50;
        graphics.fill(x, y, x + borderWidth, y + borderHeight, -13158601);
        graphics.fill(x + 1, y + 1, x + borderWidth - 1, y + borderHeight - 1, -7631989);
    }
}

