/*
 * Decompiled with CFR 0.152.
 */
package com.upo.createnetherindustry.content.blockentities;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.CreateLang;
import com.upo.createnetherindustry.content.recipes.condenser.CondenserRecipeType;
import com.upo.createnetherindustry.content.recipes.condenser.ICondensingRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class SoulCondenserBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    private static final int INPUT_TANK_CAPACITY = 4000;
    private static final int OUTPUT_TANK_CAPACITY = 4000;
    private static final int DEFAULT_PROCESSING_TIME_FALLBACK = 5120;
    protected SmartFluidTankBehaviour inputTankBehaviour;
    protected SmartFluidTankBehaviour outputTankBehaviour;
    private int progress = 0;
    @Nullable
    private RecipeHolder<ICondensingRecipe> currentActiveRecipeHolder = null;
    private int currentRecipeProcessingTime = 0;

    public SoulCondenserBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inputTankBehaviour = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 4000, false).allowInsertion().forbidExtraction().whenFluidUpdates(() -> {
            this.onInputTankContentsChanged();
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
            }
        });
        behaviours.add((BlockEntityBehaviour)this.inputTankBehaviour);
        this.outputTankBehaviour = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 1, 4000, false).allowExtraction().forbidInsertion().whenFluidUpdates(() -> {
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
            }
        });
        behaviours.add((BlockEntityBehaviour)this.outputTankBehaviour);
    }

    private void onInputTankContentsChanged() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.progress > 0 && this.currentActiveRecipeHolder != null) {
            FluidStack currentInputFluid;
            FluidStack fluidStack = currentInputFluid = this.inputTankBehaviour != null ? this.inputTankBehaviour.getPrimaryHandler().getFluid() : FluidStack.EMPTY;
            if (!this.matchRecipeInput((ICondensingRecipe)this.currentActiveRecipeHolder.value(), currentInputFluid)) {
                this.progress = 0;
            }
        }
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        if (side == Direction.DOWN) {
            return this.inputTankBehaviour != null ? this.inputTankBehaviour.getCapability() : null;
        }
        if (side == Direction.UP) {
            return this.outputTankBehaviour != null ? this.outputTankBehaviour.getCapability() : null;
        }
        return null;
    }

    public void tick() {
        super.tick();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.progress == 0) {
            if (this.currentActiveRecipeHolder != null) {
                this.clearActiveRecipeState();
            }
            if (this.tryPrepareAndStartNextRecipe()) {
                this.setChanged();
            } else {
                if (this.currentActiveRecipeHolder != null) {
                    this.clearActiveRecipeState();
                }
                return;
            }
        }
        if (this.progress > 0 && this.currentActiveRecipeHolder != null) {
            this.progress = (int)((float)this.progress + Math.abs(this.getSpeed()));
            if (this.progress >= this.currentRecipeProcessingTime) {
                this.completeRecipeCycleAndReset();
            }
            this.setChanged();
        } else if (this.progress > 0 && this.currentActiveRecipeHolder == null) {
            this.progress = 0;
            this.clearActiveRecipeState();
            this.setChanged();
        }
    }

    private boolean tryPrepareAndStartNextRecipe() {
        if (this.inputTankBehaviour == null || this.outputTankBehaviour == null || this.level == null) {
            return false;
        }
        FluidStack inputInTank = this.inputTankBehaviour.getPrimaryHandler().getFluid();
        if (inputInTank.isEmpty()) {
            return false;
        }
        RecipeManager recipeManager = this.level.getRecipeManager();
        Optional<RecipeHolder> recipeHolderOpt = recipeManager.getAllRecipesFor((RecipeType)CondenserRecipeType.SOUL_CONDENSING_RECIPE_TYPE_DEFERRED.get()).stream().filter(holder -> this.matchRecipeInput((ICondensingRecipe)holder.value(), inputInTank)).findFirst();
        if (recipeHolderOpt.isPresent()) {
            RecipeHolder holder2 = recipeHolderOpt.get();
            ICondensingRecipe recipe = (ICondensingRecipe)holder2.value();
            FluidStack recipeOutputFluid = recipe.getOutputFluid();
            FluidStack recipeInputToConsume = recipe.getInputFluid();
            SmartFluidTank outputTank = this.outputTankBehaviour.getPrimaryHandler();
            if ((outputTank.getFluid().isEmpty() || outputTank.getFluid().getFluid().isSame(recipeOutputFluid.getFluid())) && outputTank.getSpace() >= recipeOutputFluid.getAmount()) {
                this.currentActiveRecipeHolder = holder2;
                this.currentRecipeProcessingTime = recipe.getProcessingDuration();
                if (this.currentRecipeProcessingTime <= 0) {
                    this.currentRecipeProcessingTime = 5120;
                }
                this.inputTankBehaviour.getPrimaryHandler().drain(recipeInputToConsume.copy(), IFluidHandler.FluidAction.EXECUTE);
                this.progress = 1;
                return true;
            }
        }
        return false;
    }

    private void completeRecipeCycleAndReset() {
        if (this.currentActiveRecipeHolder != null && this.outputTankBehaviour != null) {
            ICondensingRecipe recipe = (ICondensingRecipe)this.currentActiveRecipeHolder.value();
            FluidStack recipeOutputFluid = recipe.getOutputFluid();
            SmartFluidTank outputTank = this.outputTankBehaviour.getPrimaryHandler();
            if ((outputTank.getFluid().isEmpty() || outputTank.getFluid().getFluid().isSame(recipeOutputFluid.getFluid())) && outputTank.getSpace() >= recipeOutputFluid.getAmount()) {
                this.outputTankBehaviour.getPrimaryHandler().fill(recipeOutputFluid.copy(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.progress = 0;
        this.clearActiveRecipeState();
    }

    private boolean matchRecipeInput(@Nullable ICondensingRecipe recipe, FluidStack inputInTank) {
        if (recipe == null || inputInTank == null || inputInTank.isEmpty()) {
            return false;
        }
        FluidStack requiredInput = recipe.getInputFluid();
        if (requiredInput == null || requiredInput.isEmpty()) {
            return false;
        }
        return inputInTank.getFluid().isSame(requiredInput.getFluid()) && inputInTank.getAmount() >= requiredInput.getAmount();
    }

    private void clearActiveRecipeState() {
        boolean changed = this.currentActiveRecipeHolder != null;
        this.currentActiveRecipeHolder = null;
        this.currentRecipeProcessingTime = 0;
        if (changed) {
            this.setChanged();
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("Progress", this.progress);
        if (this.currentActiveRecipeHolder != null) {
            compound.putString("ActiveRecipeId", this.currentActiveRecipeHolder.id().toString());
            compound.putInt("ActiveRecipeTime", this.currentRecipeProcessingTime);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        ResourceLocation recipeId;
        super.read(compound, registries, clientPacket);
        this.progress = compound.getInt("Progress");
        this.currentActiveRecipeHolder = null;
        this.currentRecipeProcessingTime = 0;
        if (compound.contains("ActiveRecipeId") && (recipeId = ResourceLocation.tryParse((String)compound.getString("ActiveRecipeId"))) != null) {
            this.currentRecipeProcessingTime = compound.getInt("ActiveRecipeTime");
        }
        if (this.progress > 0 && !compound.contains("ActiveRecipeId")) {
            this.progress = 0;
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide && this.progress > 0 && this.currentActiveRecipeHolder == null) {
            CompoundTag nbt = this.getUpdateTag((HolderLookup.Provider)this.level.registryAccess());
            if (nbt.contains("ActiveRecipeId")) {
                ResourceLocation recipeId = ResourceLocation.tryParse((String)nbt.getString("ActiveRecipeId"));
                if (recipeId != null) {
                    Recipe recipe;
                    Optional recipeOpt = this.level.getRecipeManager().byKey(recipeId);
                    if (recipeOpt.isPresent() && (recipe = ((RecipeHolder)recipeOpt.get()).value()) instanceof ICondensingRecipe) {
                        ICondensingRecipe recipeValue = (ICondensingRecipe)recipe;
                        this.currentActiveRecipeHolder = new RecipeHolder(recipeId, (Recipe)recipeValue);
                        if (this.currentRecipeProcessingTime <= 0) {
                            this.currentRecipeProcessingTime = recipeValue.getProcessingDuration();
                            if (this.currentRecipeProcessingTime <= 0) {
                                this.currentRecipeProcessingTime = 5120;
                            }
                        }
                    } else {
                        this.progress = 0;
                        this.clearActiveRecipeState();
                    }
                } else {
                    this.progress = 0;
                    this.clearActiveRecipeState();
                }
            } else {
                this.progress = 0;
                this.clearActiveRecipeState();
            }
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean addedSomething = false;
        CreateLang.translate((String)"goggle.soul_condenser.title", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        if (this.inputTankBehaviour != null) {
            addedSomething |= this.addTankToTooltip(tooltip, isPlayerSneaking, this.inputTankBehaviour.getPrimaryHandler(), "goggle.soul_condenser.input_tank", ChatFormatting.GOLD);
        }
        if (this.outputTankBehaviour != null) {
            addedSomething |= this.addTankToTooltip(tooltip, isPlayerSneaking, this.outputTankBehaviour.getPrimaryHandler(), "goggle.soul_condenser.output_tank", ChatFormatting.AQUA);
        }
        CreateLang.translate((String)"tooltip.separator", (Object[])new Object[0]).forGoggles(tooltip);
        addedSomething = true;
        float speed = Math.abs(this.getSpeed());
        CreateLang.translate((String)"tooltip.speed", (Object[])new Object[]{String.format("%.1f", Float.valueOf(speed)) + " RPM"}).style(speed > 0.0f ? ChatFormatting.GREEN : ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        if (this.level != null && this.getBlockState().getBlockHolder().isBound()) {
            double baseStressImpact = BlockStressValues.getImpact((Block)this.getBlockState().getBlock());
            if (speed > 0.0f && baseStressImpact > 0.0) {
                CreateLang.translate((String)"goggle.stress_consumption", (Object[])new Object[]{String.format("%.2f", baseStressImpact * (double)speed)}).style(ChatFormatting.GREEN).forGoggles(tooltip, 1);
            } else if (baseStressImpact > 0.0) {
                CreateLang.translate((String)"goggle.stress_impact", (Object[])new Object[]{String.format("%.1f", baseStressImpact)}).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
            }
        }
        addedSomething = true;
        if (speed > 0.0f) {
            if (this.progress > 0 && this.currentActiveRecipeHolder != null) {
                CreateLang.translate((String)"goggle.soul_condenser.status.processing", (Object[])new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip, 1);
            } else if (this.canPotentiallyStartAnyRealRecipe()) {
                CreateLang.translate((String)"goggle.soul_condenser.status.can_process", (Object[])new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            } else if (this.inputTankBehaviour != null && !this.inputTankBehaviour.getPrimaryHandler().getFluid().isEmpty()) {
                CreateLang.translate((String)"goggle.soul_condenser.status.no_recipe_for_input", (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
            } else {
                CreateLang.translate((String)"goggle.soul_condenser.status.no_input", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
            }
        } else {
            CreateLang.translate((String)"goggle.soul_condenser.status.stopped", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
        }
        return true;
    }

    protected boolean addTankToTooltip(List<Component> tooltip, boolean isPlayerSneaking, SmartFluidTank tank, String tankLabelKey, ChatFormatting fluidColor) {
        if (tank == null) {
            return false;
        }
        MutableComponent label = CreateLang.translateDirect((String)tankLabelKey, (Object[])new Object[0]);
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            CreateLang.builder().space().add(label.withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": "))).space().add(CreateLang.translateDirect((String)"goggle.fluid.empty", (Object[])new Object[0]).withStyle(ChatFormatting.DARK_GRAY)).forGoggles(tooltip);
        } else {
            CreateLang.builder().space().add(label.withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": "))).space().add(CreateLang.fluidName((FluidStack)fluidStack).add(Component.literal((String)" ")).add(CreateLang.text((String)String.format("%,d", fluidStack.getAmount())).style(fluidColor).add(CreateLang.text((String)" / ").style(ChatFormatting.GRAY)).add(CreateLang.text((String)String.format("%,d", tank.getCapacity())).style(ChatFormatting.DARK_GRAY)).add(CreateLang.text((String)" mB").style(ChatFormatting.GRAY)))).forGoggles(tooltip);
        }
        return true;
    }

    private boolean canPotentiallyStartAnyRealRecipe() {
        if (this.inputTankBehaviour == null || this.outputTankBehaviour == null || this.level == null) {
            return false;
        }
        FluidStack inputInTank = this.inputTankBehaviour.getPrimaryHandler().getFluid();
        if (inputInTank.isEmpty()) {
            return false;
        }
        RecipeManager recipeManager = this.level.getRecipeManager();
        return recipeManager.getAllRecipesFor((RecipeType)CondenserRecipeType.SOUL_CONDENSING_RECIPE_TYPE_DEFERRED.get()).stream().anyMatch(holder -> {
            ICondensingRecipe recipe = (ICondensingRecipe)holder.value();
            FluidStack requiredInput = recipe.getInputFluid();
            if (inputInTank.getFluid().isSame(requiredInput.getFluid()) && inputInTank.getAmount() >= requiredInput.getAmount()) {
                FluidStack recipeOutputFluid = recipe.getOutputFluid();
                SmartFluidTank outputTank = this.outputTankBehaviour.getPrimaryHandler();
                return (outputTank.getFluid().isEmpty() || outputTank.getFluid().getFluid().isSame(recipeOutputFluid.getFluid())) && outputTank.getSpace() >= recipeOutputFluid.getAmount();
            }
            return false;
        });
    }

    public SmartFluidTankBehaviour getInputTankBehaviour() {
        return this.inputTankBehaviour;
    }
}

