/*
 * Decompiled with CFR 0.152.
 */
package com.upo.createnetherindustry.content.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.simibubi.create.AllFluids;
import com.tterrag.registrate.builders.FluidBuilder;
import com.upo.createnetherindustry.CreateNetherIndustry;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ThickSoulSyrupType
extends AllFluids.TintedFluidType {
    private final ResourceLocation originalStillTextureRL;
    private final ResourceLocation originalFlowingTextureRL;

    private ThickSoulSyrupType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        super(properties, stillTexture, flowingTexture);
        this.originalStillTextureRL = stillTexture;
        this.originalFlowingTextureRL = flowingTexture;
    }

    public static FluidBuilder.FluidTypeFactory create() {
        return (properties, stillTexture, flowingTexture) -> new ThickSoulSyrupType(properties, stillTexture, flowingTexture);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                ResourceLocation stillRL = ThickSoulSyrupType.this.originalStillTextureRL;
                return stillRL;
            }

            public ResourceLocation getFlowingTexture() {
                ResourceLocation newFlowingRL = CreateNetherIndustry.asResource("fluid/thick_soul_syrup_flowing");
                return newFlowingRL;
            }

            public int getTintColor(FluidStack stack) {
                return ThickSoulSyrupType.this.getTintColor(stack);
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return ThickSoulSyrupType.this.getTintColor(state, getter, pos);
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, @NotNull Vector3f fluidFogColor) {
                Vector3f customFogColor = ThickSoulSyrupType.this.getCustomFogColor();
                return customFogColor == null ? fluidFogColor : customFogColor;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, @NotNull FogShape shape) {
                float modifier = ThickSoulSyrupType.this.getFogDistanceModifier();
                if (modifier != 1.0f) {
                    super.modifyFogRender(camera, mode, renderDistance, partialTick, nearDistance, farDistance, shape);
                } else {
                    super.modifyFogRender(camera, mode, renderDistance, partialTick, nearDistance, farDistance, shape);
                }
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return null;
            }
        });
    }

    protected int getTintColor(FluidStack stack) {
        return -1;
    }

    protected int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return -1;
    }

    @Nullable
    protected Vector3f getCustomFogColor() {
        return null;
    }

    protected float getFogDistanceModifier() {
        return 1.0f;
    }
}

