/*
 * Decompiled with CFR 0.152.
 */
package com.upo.createnetherindustry.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;

public class CNIRecipeParams
extends ProcessingRecipeBuilder.ProcessingRecipeParams {
    protected static final ResourceLocation UNKNOWN_ID = ResourceLocation.withDefaultNamespace((String)"unknown");

    public CNIRecipeParams(ResourceLocation id) {
        super(id);
    }

    protected static <P extends CNIRecipeParams> MapCodec<P> createCodec(Function<ResourceLocation, P> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)FluidIngredient.CODEC, (Codec)Ingredient.CODEC).listOf().fieldOf("ingredients").forGetter(CNIRecipeParams::getIngredientsForCodec), (App)Codec.either((Codec)FluidStack.CODEC, (Codec)ProcessingOutput.CODEC).listOf().fieldOf("results").forGetter(CNIRecipeParams::getResultsForCodec), (App)Codec.INT.optionalFieldOf("processingTime", (Object)0).forGetter(p -> p.processingDuration), (App)HeatCondition.CODEC.optionalFieldOf("heatRequirement", (Object)HeatCondition.NONE).forGetter(p -> p.requiredHeat)).apply((Applicative)instance, (ingredients, results, processingDuration, requiredHeat) -> {
            CNIRecipeParams params = (CNIRecipeParams)((Object)((Object)((Object)factory.apply(UNKNOWN_ID))));
            ingredients.forEach(either -> either.ifRight(arg_0 -> params.ingredients.add(arg_0)).ifLeft(arg_0 -> params.fluidIngredients.add(arg_0)));
            results.forEach(either -> either.ifRight(arg_0 -> params.results.add(arg_0)).ifLeft(arg_0 -> params.fluidResults.add(arg_0)));
            params.processingDuration = processingDuration;
            params.requiredHeat = requiredHeat;
            return params;
        }));
    }

    protected static <P extends CNIRecipeParams> StreamCodec<RegistryFriendlyByteBuf, P> createStreamCodec(Function<ResourceLocation, P> constructor) {
        return StreamCodec.of((buffer, params) -> params.writeToBuffer((RegistryFriendlyByteBuf)buffer), buffer -> {
            CNIRecipeParams params = (CNIRecipeParams)((Object)((Object)constructor.apply(UNKNOWN_ID)));
            params.readFromBuffer((RegistryFriendlyByteBuf)buffer);
            return params;
        });
    }

    protected List<Either<FluidIngredient, Ingredient>> getIngredientsForCodec() {
        ArrayList<Either<FluidIngredient, Ingredient>> combinedIngredients = new ArrayList<Either<FluidIngredient, Ingredient>>();
        this.fluidIngredients.forEach(fi -> combinedIngredients.add(Either.left((Object)fi)));
        this.ingredients.forEach(i -> combinedIngredients.add(Either.right((Object)i)));
        return combinedIngredients;
    }

    protected List<Either<FluidStack, ProcessingOutput>> getResultsForCodec() {
        ArrayList<Either<FluidStack, ProcessingOutput>> combinedResults = new ArrayList<Either<FluidStack, ProcessingOutput>>();
        this.fluidResults.forEach(fs -> combinedResults.add(Either.left((Object)fs)));
        this.results.forEach(po -> combinedResults.add(Either.right((Object)po)));
        return combinedResults;
    }

    protected void writeToBuffer(RegistryFriendlyByteBuf buffer) {
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).encode((Object)buffer, (Object)this.ingredients);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).encode((Object)buffer, (Object)this.results);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidIngredient.STREAM_CODEC).encode((Object)buffer, (Object)this.fluidIngredients);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidStack.STREAM_CODEC).encode((Object)buffer, (Object)this.fluidResults);
        ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)this.processingDuration);
        HeatCondition.STREAM_CODEC.encode((Object)buffer, (Object)this.requiredHeat);
    }

    protected void readFromBuffer(RegistryFriendlyByteBuf buffer) {
        this.ingredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).decode((Object)buffer);
        this.results = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).decode((Object)buffer);
        this.fluidIngredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidIngredient.STREAM_CODEC).decode((Object)buffer);
        this.fluidResults = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidStack.STREAM_CODEC).decode((Object)buffer);
        this.processingDuration = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer);
        this.requiredHeat = (HeatCondition)HeatCondition.STREAM_CODEC.decode((Object)buffer);
    }
}

