/*
 * Decompiled with CFR 0.152.
 */
package com.upo.createnetherindustry.event;

import com.upo.createnetherindustry.registry.CNIItems;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class SoulBlazeToolEvents {
    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        float currentSpeed;
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        ItemStack mainHandStack = player.getMainHandItem();
        Item heldItem = mainHandStack.getItem();
        if ((heldItem == CNIItems.SOUL_BLAZE_PICKAXE.get() || heldItem == CNIItems.SOUL_BLAZE_AXE.get()) && player.level().dimension().equals(Level.NETHER) && (currentSpeed = event.getNewSpeed()) > 0.0f) {
            event.setNewSpeed(currentSpeed * 2.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDamageModify(LivingDamageEvent.Pre event) {
        Player playerAttacker;
        ItemStack heldItemStack;
        DamageSource damageSource = event.getSource();
        Entity attacker = damageSource.getEntity();
        if (attacker instanceof Player && (heldItemStack = (playerAttacker = (Player)attacker).getMainHandItem()).getItem() == CNIItems.SOUL_BLAZE_AXE.get() && playerAttacker.level().dimension().equals(Level.NETHER)) {
            float currentDamage = event.getNewDamage();
            event.setNewDamage(currentDamage * 2.0f);
        }
    }
}

