/*
 * Decompiled with CFR 0.152.
 */
package com.upo.createnetherindustry.event;

import com.upo.createnetherindustry.content.blocks.corp.WitherBushCropBlock;
import com.upo.createnetherindustry.registry.CNIBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class WitherBushPlantingHandler {
    @SubscribeEvent
    public static void onPlayerRightClickBlockPlantWitherBush(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Level level = event.getLevel();
        BlockPos clickedPos = event.getPos();
        Player player = event.getEntity();
        ItemStack heldStack = event.getItemStack();
        InteractionHand hand = event.getHand();
        if (heldStack.getItem() != Items.WITHER_ROSE) {
            return;
        }
        BlockState clickedBlockState = level.getBlockState(clickedPos);
        if (!clickedBlockState.is(CNIBlocks.WARPED_NYLIUM_FARMLAND)) {
            return;
        }
        BlockPos plantPos = clickedPos.above();
        if (!level.getBlockState(plantPos).isAir()) {
            return;
        }
        BlockState cropToPlace = ((WitherBushCropBlock)((Object)CNIBlocks.WITHER_BUSH_CROP.get())).defaultBlockState();
        if (!cropToPlace.canSurvive((LevelReader)level, plantPos)) {
            return;
        }
        if (!level.isClientSide) {
            level.setBlock(plantPos, cropToPlace, 3);
            BlockState placedCropState = level.getBlockState(plantPos);
            level.playSound(null, plantPos, placedCropState.getSoundType((LevelReader)level, plantPos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                heldStack.shrink(1);
            }
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
    }
}

