/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticedges.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticedges.block.custom.CurtainRodBlock;
import net.alminoris.aestheticedges.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticedges.item.ModItems;
import net.alminoris.aestheticedges.util.helper.BlockSetsHelper;
import net.alminoris.aestheticedges.util.helper.BlockShape;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"aestheticedges");
    public static final Dictionary<String, DeferredBlock<Block>> CURBSTONES = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("curbstone_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(0.0, 0.0, 0.0, 16.0, 8.0, 8.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> CURBSTONES_INNER = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("curbstone_inner_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(0.0, 0.0, 0.0, 8.0, 8.0, 8.0), new BlockShape(8.0, 0.0, 0.0, 16.0, 8.0, 16.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> CURBSTONES_OUTER = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("curbstone_outer_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(8.0, 0.0, 0.0, 16.0, 8.0, 8.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> HIGH_CURBSTONES = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("curbstone_high_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(0.0, 0.0, 0.0, 16.0, 16.0, 8.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> HIGH_CURBSTONES_INNER = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("curbstone_high_inner_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(0.0, 0.0, 0.0, 8.0, 16.0, 8.0), new BlockShape(8.0, 0.0, 0.0, 16.0, 16.0, 16.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> HIGH_CURBSTONES_OUTER = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("curbstone_high_outer_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(8.0, 0.0, 0.0, 16.0, 16.0, 8.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> SIMPLE_CURBS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("simple_curb_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(0.0, 0.0, 0.0, 16.0, 8.0, 8.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> SIMPLE_CURBS_INNER = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("simple_curb_inner_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(0.0, 0.0, 0.0, 8.0, 8.0, 8.0), new BlockShape(8.0, 0.0, 0.0, 16.0, 8.0, 16.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> SIMPLE_CURBS_OUTER = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("simple_curb_outer_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(8.0, 0.0, 0.0, 16.0, 8.0, 8.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> BASEBOARDS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("baseboard_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), new BlockShape(0.0, 0.0, 0.0, 16.0, 3.0, 3.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> BASEBOARDS_INNER = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("baseboard_inner_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), new BlockShape(0.0, 0.0, 0.0, 16.0, 3.0, 3.0), new BlockShape(13.0, 0.0, 0.0, 16.0, 3.0, 16.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> BASEBOARDS_OUTER = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("baseboard_outer_" + name, () -> new YAxisRotatedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS), new BlockShape(13.0, 0.0, 0.0, 16.0, 3.0, 3.0))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> CURTAIN_RODS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("curtain_rod_" + name, () -> new CurtainRodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD), new BlockShape(0.0, 14.0, 0.0, 16.0, 17.0, 3.0))));
            }
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock("curtain_rod_" + name, () -> new CurtainRodBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), new BlockShape(0.0, 14.0, 0.0, 16.0, 17.0, 3.0))));
            }
        }
    };

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

