/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticedges.datagen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import net.alminoris.aestheticedges.block.ModBlocks;
import net.alminoris.aestheticedges.util.helper.BlockSetsHelper;
import net.alminoris.aestheticedges.util.helper.ModJsonHelper;
import net.alminoris.aestheticedges.util.helper.ModJsonTemplates;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "aestheticedges", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (String name : BlockSetsHelper.STONES) {
            this.registerCurtainRod(ModBlocks.CURTAIN_RODS.get(name), name, name, "minecraft");
            this.registerEdge(ModJsonTemplates.CURBSTONE_MODEL_TEMPLATE, ModBlocks.CURBSTONES.get(name), name, "minecraft");
            this.registerEdge(ModJsonTemplates.CURBSTONE_INNER_MODEL_TEMPLATE, ModBlocks.CURBSTONES_INNER.get(name), name, "minecraft");
            this.registerEdge(ModJsonTemplates.CURBSTONE_OUTER_MODEL_TEMPLATE, ModBlocks.CURBSTONES_OUTER.get(name), name, "minecraft");
            this.registerEdge(ModJsonTemplates.HIGH_CURBSTONE_MODEL_TEMPLATE, ModBlocks.HIGH_CURBSTONES.get(name), name, "minecraft");
            this.registerEdge(ModJsonTemplates.HIGH_CURBSTONE_INNER_MODEL_TEMPLATE, ModBlocks.HIGH_CURBSTONES_INNER.get(name), name, "minecraft");
            this.registerEdge(ModJsonTemplates.HIGH_CURBSTONE_OUTER_MODEL_TEMPLATE, ModBlocks.HIGH_CURBSTONES_OUTER.get(name), name, "minecraft");
            this.registerEdge(ModJsonTemplates.SIMPLE_CURB_MODEL_TEMPLATE, ModBlocks.SIMPLE_CURBS.get(name), name, "minecraft");
            this.registerEdge(ModJsonTemplates.SIMPLE_CURB_INNER_MODEL_TEMPLATE, ModBlocks.SIMPLE_CURBS_INNER.get(name), name, "minecraft");
            this.registerEdge(ModJsonTemplates.SIMPLE_CURB_OUTER_MODEL_TEMPLATE, ModBlocks.SIMPLE_CURBS_OUTER.get(name), name, "minecraft");
        }
        for (String name : BlockSetsHelper.EXTRA_STONES_WF) {
            this.registerCurtainRod(ModBlocks.CURTAIN_RODS.get(name), name, name, "aestheticedges");
            this.registerEdge(ModJsonTemplates.CURBSTONE_MODEL_TEMPLATE, ModBlocks.CURBSTONES.get(name), name, "aestheticedges");
            this.registerEdge(ModJsonTemplates.CURBSTONE_INNER_MODEL_TEMPLATE, ModBlocks.CURBSTONES_INNER.get(name), name, "aestheticedges");
            this.registerEdge(ModJsonTemplates.CURBSTONE_OUTER_MODEL_TEMPLATE, ModBlocks.CURBSTONES_OUTER.get(name), name, "aestheticedges");
            this.registerEdge(ModJsonTemplates.HIGH_CURBSTONE_MODEL_TEMPLATE, ModBlocks.HIGH_CURBSTONES.get(name), name, "aestheticedges");
            this.registerEdge(ModJsonTemplates.HIGH_CURBSTONE_INNER_MODEL_TEMPLATE, ModBlocks.HIGH_CURBSTONES_INNER.get(name), name, "aestheticedges");
            this.registerEdge(ModJsonTemplates.HIGH_CURBSTONE_OUTER_MODEL_TEMPLATE, ModBlocks.HIGH_CURBSTONES_OUTER.get(name), name, "aestheticedges");
            this.registerEdge(ModJsonTemplates.SIMPLE_CURB_MODEL_TEMPLATE, ModBlocks.SIMPLE_CURBS.get(name), name, "aestheticedges");
            this.registerEdge(ModJsonTemplates.SIMPLE_CURB_INNER_MODEL_TEMPLATE, ModBlocks.SIMPLE_CURBS_INNER.get(name), name, "aestheticedges");
            this.registerEdge(ModJsonTemplates.SIMPLE_CURB_OUTER_MODEL_TEMPLATE, ModBlocks.SIMPLE_CURBS_OUTER.get(name), name, "aestheticedges");
        }
        for (String name : BlockSetsHelper.WOODS) {
            String logName = name.equals("crimson") || name.equals("warped") ? "stem" : (name.equals("bamboo") ? "block" : "log");
            this.registerCurtainRod(ModBlocks.CURTAIN_RODS.get(name), name, "stripped_" + name + "_" + logName, "minecraft");
            this.registerEdge(ModJsonTemplates.BASEBOARD_MODEL_TEMPLATE, ModBlocks.BASEBOARDS.get(name), name + "_planks", "minecraft");
            this.registerEdge(ModJsonTemplates.BASEBOARD_INNER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_INNER.get(name), name + "_planks", "minecraft");
            this.registerEdge(ModJsonTemplates.BASEBOARD_OUTER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_OUTER.get(name), name + "_planks", "minecraft");
        }
        for (String name : BlockSetsHelper.EXTRA_WOODS_AN) {
            this.registerCurtainRod(ModBlocks.CURTAIN_RODS.get(name), name, "stripped_" + name + "_log", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_MODEL_TEMPLATE, ModBlocks.BASEBOARDS.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_INNER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_INNER.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_OUTER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_OUTER.get(name), name + "_planks", "aestheticedges");
        }
        for (String name : BlockSetsHelper.EXTRA_WOODS_WF) {
            this.registerCurtainRod(ModBlocks.CURTAIN_RODS.get(name), name, "stripped_" + name + "_log", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_MODEL_TEMPLATE, ModBlocks.BASEBOARDS.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_INNER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_INNER.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_OUTER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_OUTER.get(name), name + "_planks", "aestheticedges");
        }
        for (String name : BlockSetsHelper.WT_WOOD_NAMES) {
            this.registerCurtainRod(ModBlocks.CURTAIN_RODS.get(name), name, "stripped_" + name + "_log", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_MODEL_TEMPLATE, ModBlocks.BASEBOARDS.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_INNER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_INNER.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_OUTER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_OUTER.get(name), name + "_planks", "aestheticedges");
        }
        for (String name : BlockSetsHelper.ST_WOOD_NAMES) {
            this.registerCurtainRod(ModBlocks.CURTAIN_RODS.get(name), name, "stripped_" + name + "_log", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_MODEL_TEMPLATE, ModBlocks.BASEBOARDS.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_INNER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_INNER.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_OUTER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_OUTER.get(name), name + "_planks", "aestheticedges");
        }
        for (String name : BlockSetsHelper.MT_WOOD_NAMES) {
            this.registerCurtainRod(ModBlocks.CURTAIN_RODS.get(name), name, "stripped_" + name + "_log", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_MODEL_TEMPLATE, ModBlocks.BASEBOARDS.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_INNER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_INNER.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_OUTER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_OUTER.get(name), name + "_planks", "aestheticedges");
        }
        for (String name : BlockSetsHelper.NSS_WOOD_NAMES) {
            this.registerCurtainRod(ModBlocks.CURTAIN_RODS.get(name), name, "stripped_" + name + "_log", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_MODEL_TEMPLATE, ModBlocks.BASEBOARDS.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_INNER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_INNER.get(name), name + "_planks", "aestheticedges");
            this.registerEdge(ModJsonTemplates.BASEBOARD_OUTER_MODEL_TEMPLATE, ModBlocks.BASEBOARDS_OUTER.get(name), name + "_planks", "aestheticedges");
        }
    }

    public final void registerCurtainRod(DeferredBlock<Block> curtainRod, String matName, String name, String modId) {
        for (String colorName : BlockSetsHelper.COLORS) {
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "normal", false, false);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "left", false, false);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "right", false, false);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "center", false, false);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "normal", true, false);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "left", true, false);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "right", true, false);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "center", true, false);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "normal", true, true);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "left", true, true);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "right", true, true);
            ModJsonHelper.createCurtainRodBlockModel(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), modId + ":block/" + name, colorName, "center", true, true);
        }
        String filePath = System.getProperty("user.dir").replace("run-data", "src\\main\\resources") + "/assets/aestheticedges/blockstates/curtain_rod_template.json";
        String s = "";
        try {
            s = Files.readString(Paths.get(filePath, new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ModJsonHelper.createBlockstate(BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath(), matName, s);
        this.blockItem(curtainRod, "block/" + BuiltInRegistries.BLOCK.getKey((Object)((Block)curtainRod.get())).getPath());
    }

    public final void registerEdge(String jsonContext, DeferredBlock<Block> curbstone, String name, String modId) {
        ModJsonHelper.createBlockModel(jsonContext, BuiltInRegistries.BLOCK.getKey((Object)((Block)curbstone.get())).getPath(), modId + ":block/" + name);
        ModJsonHelper.createBlockstate(BuiltInRegistries.BLOCK.getKey((Object)((Block)curbstone.get())).getPath(), BuiltInRegistries.BLOCK.getKey((Object)((Block)curbstone.get())).getPath(), ModJsonTemplates.YAXIS_ROTATED_BLOCKSTATE_TEMPLATE);
        this.blockItem(curbstone, "block/" + BuiltInRegistries.BLOCK.getKey((Object)((Block)curbstone.get())).getPath());
    }

    private void blockItem(DeferredBlock<? extends Block> blockRegistryObject, String name) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("aestheticedges:" + name));
    }
}

