/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticedges.block.custom;

import net.alminoris.aestheticedges.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticedges.item.ModItems;
import net.alminoris.aestheticedges.util.ModTags;
import net.alminoris.aestheticedges.util.helper.BlockShape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class CurtainRodBlock
extends YAxisRotatedBlock {
    public static final EnumProperty<Color> COLOR = EnumProperty.create((String)"color", Color.class);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);
    public static final BooleanProperty DRESSED = BooleanProperty.create((String)"dressed");
    public static final BooleanProperty OPENED = BooleanProperty.create((String)"opened");

    public CurtainRodBlock(BlockBehaviour.Properties settings, BlockShape ... shapes) {
        super(settings, shapes);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(VARIANT, (Comparable)((Object)Variant.NORMAL))).setValue((Property)DRESSED, (Comparable)Boolean.valueOf(false))).setValue(COLOR, (Comparable)((Object)Color.BLACK))).setValue((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{VARIANT, DRESSED, COLOR, OPENED});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        boolean currentDressed = (Boolean)state.getValue((Property)DRESSED);
        boolean currentOpened = (Boolean)state.getValue((Property)OPENED);
        Variant currentVariant = (Variant)((Object)state.getValue(VARIANT));
        if (stack.is(ModTags.Items.CURTAINS) && !currentDressed) {
            if (!world.isClientSide) {
                Direction currentFacing = (Direction)state.getValue((Property)FACING);
                String colorName = ForgeRegistries.ITEMS.getKey((Object)stack.getItem()).getPath().replace("curtain_", "");
                world.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue(VARIANT, (Comparable)((Object)currentVariant))).setValue((Property)DRESSED, (Comparable)Boolean.valueOf(true))).setValue((Property)OPENED, (Comparable)Boolean.valueOf(currentOpened))).setValue(COLOR, (Comparable)((Object)Color.fromString(colorName))), 3);
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.isEmpty() && currentDressed) {
            if (!world.isClientSide) {
                Direction currentFacing = (Direction)state.getValue((Property)FACING);
                Color currentColor = (Color)((Object)state.getValue(COLOR));
                world.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue(VARIANT, (Comparable)((Object)currentVariant))).setValue((Property)DRESSED, (Comparable)Boolean.valueOf(currentDressed))).setValue((Property)OPENED, (Comparable)Boolean.valueOf(!currentOpened))).setValue(COLOR, (Comparable)((Object)currentColor)), 3);
                if (stack.getDamageValue() < stack.getMaxDamage() - 1) {
                    stack.setDamageValue(stack.getDamageValue() + 1);
                } else {
                    stack.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.is((Item)ModItems.CURTAIN_REMOVER.get())) {
            if (!world.isClientSide) {
                Direction currentFacing = (Direction)state.getValue((Property)FACING);
                Color currentColor = (Color)((Object)state.getValue(COLOR));
                String colorName = currentColor.getSerializedName();
                world.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue(VARIANT, (Comparable)((Object)currentVariant))).setValue((Property)DRESSED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPENED, (Comparable)Boolean.valueOf(currentOpened))).setValue(COLOR, (Comparable)((Object)currentColor)), 3);
                if (stack.getDamageValue() < stack.getMaxDamage() - 1) {
                    stack.setDamageValue(stack.getDamageValue() + 1);
                } else {
                    stack.shrink(1);
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"aestheticedges", (String)("curtain_" + colorName)));
                ItemStack carpetStack = new ItemStack((ItemLike)item);
                if (!player.getInventory().add(carpetStack)) {
                    player.drop(carpetStack, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateCurtainRodVariant(state, world, pos);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        this.updateSurroundingCurtainRodes(world, pos);
    }

    private void updateSurroundingCurtainRodes(Level world, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.relative(dir);
            BlockState neighborState = world.getBlockState(neighborPos);
            if (neighborState.getBlock() != this) continue;
            world.setBlock(neighborPos, this.updateCurtainRodVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateCurtainRodVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.relative(facing.getCounterClockWise());
        BlockPos rightPos = pos.relative(facing.getClockWise());
        boolean leftConnected = this.isCurtainRod(world, leftPos, facing);
        boolean rightConnected = this.isCurtainRod(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.setValue(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isCurtainRod(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.getBlockState(pos);
        return state.getBlock() == this && state.getValue((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        LEFT("left"),
        RIGHT("right"),
        CENTER("center");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public static Variant fromString(String name) {
            for (Variant inside : Variant.values()) {
                if (!inside.name.equalsIgnoreCase(name)) continue;
                return inside;
            }
            throw new IllegalArgumentException("No enum constant for name: " + name);
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum Color implements StringRepresentable
    {
        BLACK("black"),
        BROWN("brown"),
        GRAY("gray"),
        LIGHT_GRAY("light_gray"),
        WHITE("white"),
        RED("red"),
        ORANGE("orange"),
        YELLOW("yellow"),
        PURPLE("purple"),
        MAGENTA("magenta"),
        PINK("pink"),
        BLUE("blue"),
        CYAN("cyan"),
        LIGHT_BLUE("light_blue"),
        GREEN("green"),
        LIME("lime");

        private final String name;

        private Color(String name) {
            this.name = name;
        }

        public static Color fromString(String name) {
            for (Color inside : Color.values()) {
                if (!inside.name.equalsIgnoreCase(name)) continue;
                return inside;
            }
            throw new IllegalArgumentException("No enum constant for name: " + name);
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

