/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticedges.block.custom;

import java.util.ArrayList;
import java.util.List;
import net.alminoris.aestheticedges.util.helper.BlockShape;
import net.alminoris.aestheticedges.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class YAxisRotatedBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    List<BlockShape> shapes;

    public YAxisRotatedBlock(BlockBehaviour.Properties settings, BlockShape ... shapes) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.shapes = List.of(shapes);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        for (BlockShape shape : this.shapes) {
            VoxelShape voxelShape = YAxisRotatedBlock.createCuboidShape(shape.getShapeCoords());
            boxes.add(voxelShape.bounds());
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    private static VoxelShape createCuboidShape(List<Double> shapeCoords) {
        return Block.box((double)shapeCoords.get(0), (double)shapeCoords.get(1), (double)shapeCoords.get(2), (double)shapeCoords.get(3), (double)shapeCoords.get(4), (double)shapeCoords.get(5));
    }
}

