/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticedges.block.custom;

import net.alminoris.aestheticedges.block.custom.YAxisRotatedBlock;
import net.alminoris.aestheticedges.item.ModItems;
import net.alminoris.aestheticedges.util.ModTags;
import net.alminoris.aestheticedges.util.helper.BlockShape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CurtainRodBlock
extends YAxisRotatedBlock {
    public static final EnumProperty<Color> COLOR = EnumProperty.m_61587_((String)"color", Color.class);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);
    public static final BooleanProperty DRESSED = BooleanProperty.m_61465_((String)"dressed");
    public static final BooleanProperty OPENED = BooleanProperty.m_61465_((String)"opened");

    public CurtainRodBlock(BlockBehaviour.Properties settings, BlockShape ... shapes) {
        super(settings, shapes);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL))).m_61124_((Property)DRESSED, (Comparable)Boolean.valueOf(false))).m_61124_(COLOR, (Comparable)((Object)Color.BLACK))).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT, DRESSED, COLOR, OPENED});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        boolean currentDressed = (Boolean)state.m_61143_((Property)DRESSED);
        boolean currentOpened = (Boolean)state.m_61143_((Property)OPENED);
        Variant currentVariant = (Variant)((Object)state.m_61143_(VARIANT));
        if (stack.m_204117_(ModTags.Items.CURTAINS) && !currentDressed) {
            if (!world.f_46443_) {
                Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
                String colorName = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.m_41720_()).m_135815_().replace("curtain_", "");
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_(VARIANT, (Comparable)((Object)currentVariant))).m_61124_((Property)DRESSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(currentOpened))).m_61124_(COLOR, (Comparable)((Object)Color.fromString(colorName))), 3);
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41619_() && currentDressed) {
            if (!world.f_46443_) {
                Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
                Color currentColor = (Color)((Object)state.m_61143_(COLOR));
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_(VARIANT, (Comparable)((Object)currentVariant))).m_61124_((Property)DRESSED, (Comparable)Boolean.valueOf(currentDressed))).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(!currentOpened))).m_61124_(COLOR, (Comparable)((Object)currentColor)), 3);
                if (stack.m_41773_() < stack.m_41776_() - 1) {
                    stack.m_41721_(stack.m_41773_() + 1);
                } else {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)ModItems.CURTAIN_REMOVER.get())) {
            if (!world.f_46443_) {
                Direction currentFacing = (Direction)state.m_61143_((Property)FACING);
                Color currentColor = (Color)((Object)state.m_61143_(COLOR));
                String colorName = currentColor.m_7912_();
                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)currentFacing)).m_61124_(VARIANT, (Comparable)((Object)currentVariant))).m_61124_((Property)DRESSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(currentOpened))).m_61124_(COLOR, (Comparable)((Object)currentColor)), 3);
                if (stack.m_41773_() < stack.m_41776_() - 1) {
                    stack.m_41721_(stack.m_41773_() + 1);
                } else {
                    stack.m_41774_(1);
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"aestheticedges", (String)("curtain_" + colorName)));
                ItemStack carpetStack = new ItemStack((ItemLike)item);
                if (!player.m_150109_().m_36054_(carpetStack)) {
                    player.m_36176_(carpetStack, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateCurtainRodVariant(state, world, pos);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        this.updateSurroundingCurtainRodes(world, pos);
    }

    private void updateSurroundingCurtainRodes(Level world, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_142300_(dir);
            BlockState neighborState = world.m_8055_(neighborPos);
            if (neighborState.m_60734_() != this) continue;
            world.m_7731_(neighborPos, this.updateCurtainRodVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateCurtainRodVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos leftPos = pos.m_142300_(facing.m_122428_());
        BlockPos rightPos = pos.m_142300_(facing.m_122427_());
        boolean leftConnected = this.isCurtainRod(world, leftPos, facing);
        boolean rightConnected = this.isCurtainRod(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isCurtainRod(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this && state.m_61143_((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        LEFT("left"),
        RIGHT("right"),
        CENTER("center");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public static Variant fromString(String name) {
            for (Variant inside : Variant.values()) {
                if (!inside.name.equalsIgnoreCase(name)) continue;
                return inside;
            }
            throw new IllegalArgumentException("No enum constant for name: " + name);
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum Color implements StringRepresentable
    {
        BLACK("black"),
        BROWN("brown"),
        GRAY("gray"),
        LIGHT_GRAY("light_gray"),
        WHITE("white"),
        RED("red"),
        ORANGE("orange"),
        YELLOW("yellow"),
        PURPLE("purple"),
        MAGENTA("magenta"),
        PINK("pink"),
        BLUE("blue"),
        CYAN("cyan"),
        LIGHT_BLUE("light_blue"),
        GREEN("green"),
        LIME("lime");

        private final String name;

        private Color(String name) {
            this.name = name;
        }

        public static Color fromString(String name) {
            for (Color inside : Color.values()) {
                if (!inside.name.equalsIgnoreCase(name)) continue;
                return inside;
            }
            throw new IllegalArgumentException("No enum constant for name: " + name);
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

