/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticedges.datagen;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.alminoris.aestheticedges.util.helper.BlockSetsHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModLanguageProviderEnUs
extends LanguageProvider {
    public ModLanguageProviderEnUs(DataGenerator output) {
        super(output, "aestheticedges", "en_us");
    }

    public void addTranslations() {
        String displayName;
        String[] parts;
        String pathNew;
        String path;
        ResourceLocation id;
        for (Block block : ForgeRegistries.BLOCKS) {
            id = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            pathNew = path = id.m_135815_();
            pathNew = ModLanguageProviderEnUs.movePrefix(ModLanguageProviderEnUs.movePrefix(path, BlockSetsHelper.getStones()), BlockSetsHelper.getWoods());
            parts = pathNew.split("_");
            displayName = Arrays.stream(parts).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
            displayName = displayName.replace(" Nss", "");
            this.add("block.aestheticedges." + path, displayName);
        }
        for (Item item : ForgeRegistries.ITEMS) {
            id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
            pathNew = path = id.m_135815_();
            pathNew = ModLanguageProviderEnUs.movePrefix(path, BlockSetsHelper.COLORS);
            parts = pathNew.split("_");
            displayName = Arrays.stream(parts).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
            this.add("item.aestheticedges." + path, displayName);
        }
        this.add("itemGroup.aestheticedges.aedgstab", "Aesthetic Edges");
    }

    public static String movePrefix(String input, String[] arr) {
        String[] sorted = Arrays.copyOf(arr, arr.length);
        Arrays.sort(sorted, (a, b) -> Integer.compare(b.length(), a.length()));
        for (String el : sorted) {
            String suffix = "_" + el;
            if (!input.endsWith(suffix)) continue;
            String base = input.substring(0, input.length() - suffix.length());
            return base.isEmpty() ? el : el + "_" + base;
        }
        return input;
    }
}

