/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.block;

import com.mojang.serialization.MapCodec;
import com.mrbysco.simpleteleporters.block.entity.TeleporterBlockEntity;
import com.mrbysco.simpleteleporters.config.SimpleTeleportersConfig;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlockEntities;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersComponents;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersItems;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersSoundEvents;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TeleporterBlock
extends BaseEntityBlock {
    public static final MapCodec<TeleporterBlock> CODEC = TeleporterBlock.simpleCodec(TeleporterBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");
    protected static final VoxelShape SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.38, (double)1.0);

    public MapCodec<TeleporterBlock> codec() {
        return CODEC;
    }

    public TeleporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ON, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean p_451772_) {
        if (!level.isClientSide() && entity instanceof ServerPlayer) {
            BlockEntity blockEntity;
            ServerPlayer player = (ServerPlayer)entity;
            if (entity.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof TeleporterBlockEntity) {
                TeleporterBlockEntity teleporter = (TeleporterBlockEntity)blockEntity;
                if (!teleporter.hasCrystal()) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.no_crystal").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                } else if (!teleporter.isInDimension(entity)) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.wrong_dimension").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                } else if (!teleporter.isCoolingDown()) {
                    ServerLevel targetLevel;
                    GlobalPos globalPos = (GlobalPos)teleporter.getCrystal().get(SimpleTeleportersComponents.GLOBAL_POS);
                    if (globalPos == null) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.unlinked_teleporter").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                        return;
                    }
                    BlockPos teleportPos = globalPos.pos();
                    ResourceKey targetDimension = globalPos.dimension();
                    MinecraftServer server = level.getServer();
                    ServerLevel serverLevel = targetLevel = server != null ? server.getLevel(targetDimension) : null;
                    if (targetLevel == null) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.invalid_position").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                    } else if (targetLevel.getBlockState(teleportPos).isSuffocating((BlockGetter)targetLevel, teleportPos)) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.invalid_position").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                    } else {
                        Vec3 targetPos = new Vec3((double)teleportPos.getX() + 0.5, (double)teleportPos.getY(), (double)teleportPos.getZ() + 0.5);
                        if (targetDimension.equals(level.dimension())) {
                            player.hurtMarked = true;
                            player.connection.teleport(targetPos.x(), targetPos.y(), targetPos.z(), entity.getYRot(), entity.getXRot());
                        } else {
                            player.teleportTo(targetLevel, targetPos.x(), targetPos.y(), targetPos.z(), Set.of(), entity.getYRot(), entity.getXRot(), true);
                        }
                        player.setDeltaMovement(0.0, 0.0, 0.0);
                        player.hasImpulse = true;
                        level.playSound(null, pos, (SoundEvent)SimpleTeleportersSoundEvents.TELEPORTER_TELEPORT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        teleporter.setCooldown(10);
                        BlockEntity down = targetLevel.getBlockEntity(teleportPos.below());
                        if (down instanceof TeleporterBlockEntity) {
                            TeleporterBlockEntity tpDown = (TeleporterBlockEntity)down;
                            tpDown.setCooldown(10);
                        }
                    }
                }
            }
        }
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TeleporterBlockEntity) {
            ItemStack crystal;
            TeleporterBlockEntity teleporter = (TeleporterBlockEntity)blockEntity;
            Item item = stack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                DyeColor newColor = dyeItem.getDyeColor();
                if (teleporter.getColor() != newColor) {
                    if (!level.isClientSide()) {
                        teleporter.setColor(newColor);
                        if (!player.getAbilities().instabuild) {
                            stack.shrink(1);
                        }
                    }
                    level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (teleporter.hasCrystal()) {
                crystal = teleporter.getCrystal();
                if (!player.addItem(crystal)) {
                    player.drop(crystal, true);
                }
                player.playSound((SoundEvent)SimpleTeleportersSoundEvents.TELEPORTER_CRYSTAL_REMOVED.get(), 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ON, (Comparable)Boolean.valueOf(false)));
                teleporter.setCrystal(ItemStack.EMPTY);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return InteractionResult.SUCCESS;
            }
            if (!stack.isEmpty() && (stack.is((Item)SimpleTeleportersItems.ENDER_SHARD.get()) || stack.is((Item)SimpleTeleportersItems.ENHANCED_ENDER_SHARD.get()))) {
                if (stack.has(SimpleTeleportersComponents.GLOBAL_POS)) {
                    player.playSound((SoundEvent)SimpleTeleportersSoundEvents.TELEPORTER_CRYSTAL_INSERTED.get(), 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ON, (Comparable)Boolean.valueOf(true)));
                    crystal = stack.split(1);
                    teleporter.setCrystal(crystal);
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.unlinked_shard").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
            }
        }
        return InteractionResult.PASS;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        TeleporterBlockEntity teleporter;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TeleporterBlockEntity && (teleporter = (TeleporterBlockEntity)blockEntity).hasCrystal()) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)teleporter.getCrystal());
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return SHAPE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ON}).add(new Property[]{WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TeleporterBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)ON)).booleanValue() && !SimpleTeleportersConfig.CLIENT.disableParticles.getAsBoolean()) {
            for (int i = 0; i < 15; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)pos.getX() + 0.2f + random.nextFloat() / 2.0f), (double)((float)pos.getY() + 0.4f), (double)((float)pos.getZ() + 0.2f + random.nextFloat() / 2.0f), 0.0, (double)random.nextFloat(), 0.0);
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        FluidState fluidState = placeContext.getLevel().getFluidState(placeContext.getClickedPos());
        boolean isWater = fluidState.getType().equals(Fluids.WATER);
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TeleporterBlock.createTickerHelper(type, SimpleTeleportersBlockEntities.TELEPORTER.get(), (BlockEntityTicker)(level.isClientSide() ? null : TeleporterBlockEntity::serverTick));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof TeleporterBlockEntity) {
            TeleporterBlockEntity teleporter = (TeleporterBlockEntity)blockEntity;
            boolean isPowered = level.hasNeighborSignal(pos);
            boolean wasPowered = teleporter.wasPowered();
            if (isPowered && !wasPowered) {
                this.teleportAllEntities(level, pos, teleporter);
            }
            teleporter.setPowered(isPowered);
        }
    }

    private void teleportAllEntities(Level level, BlockPos pos, TeleporterBlockEntity teleporter) {
        ServerLevel targetLevel;
        if (!teleporter.hasCrystal() || teleporter.isCoolingDown()) {
            return;
        }
        GlobalPos globalPos = (GlobalPos)teleporter.getCrystal().get(SimpleTeleportersComponents.GLOBAL_POS);
        if (globalPos == null) {
            return;
        }
        BlockPos teleportPos = globalPos.pos();
        ResourceKey targetDimension = globalPos.dimension();
        MinecraftServer server = level.getServer();
        ServerLevel serverLevel = targetLevel = server != null ? server.getLevel(targetDimension) : null;
        if (targetLevel == null || targetLevel.getBlockState(teleportPos).isSuffocating((BlockGetter)targetLevel, teleportPos)) {
            return;
        }
        AABB area = new AABB(pos).inflate(0.1, 0.5, 0.1).move(0.0, 0.5, 0.0);
        List entities = level.getEntities(null, area);
        if (entities.isEmpty()) {
            return;
        }
        boolean teleportedAny = false;
        Vec3 targetPos = new Vec3((double)teleportPos.getX() + 0.5, (double)teleportPos.getY(), (double)teleportPos.getZ() + 0.5);
        boolean crossDimensional = !targetDimension.equals(level.dimension());
        for (Entity entity : entities) {
            if (!teleporter.isInDimension(entity)) continue;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (crossDimensional) {
                    player.teleportTo(targetLevel, targetPos.x(), targetPos.y(), targetPos.z(), Set.of(), entity.getYRot(), entity.getXRot(), true);
                } else {
                    player.hurtMarked = true;
                    player.connection.teleport(targetPos.x(), targetPos.y(), targetPos.z(), entity.getYRot(), entity.getXRot());
                }
                player.setDeltaMovement(0.0, 0.0, 0.0);
                player.hasImpulse = true;
            } else {
                if (crossDimensional) {
                    entity.teleportTo(targetLevel, targetPos.x(), targetPos.y(), targetPos.z(), Set.of(), entity.getYRot(), entity.getXRot(), true);
                } else {
                    entity.teleportTo(targetPos.x(), targetPos.y(), targetPos.z());
                }
                entity.setDeltaMovement(0.0, 0.0, 0.0);
            }
            teleportedAny = true;
        }
        if (teleportedAny) {
            level.playSound(null, pos, (SoundEvent)SimpleTeleportersSoundEvents.TELEPORTER_TELEPORT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            teleporter.setCooldown(10);
            BlockEntity down = targetLevel.getBlockEntity(teleportPos.below());
            if (down instanceof TeleporterBlockEntity) {
                TeleporterBlockEntity tpDown = (TeleporterBlockEntity)down;
                tpDown.setCooldown(10);
            }
        }
    }
}

