/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.simpleteleporters.block.entity.TeleporterBlockEntity;
import com.mrbysco.simpleteleporters.client.TeleporterRenderState;
import com.mrbysco.simpleteleporters.config.SimpleTeleportersConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class TeleporterBER
implements BlockEntityRenderer<TeleporterBlockEntity, TeleporterRenderState> {
    private final Font font;
    private final EntityRenderDispatcher entityRenderDispatcher;

    public TeleporterBER(BlockEntityRendererProvider.Context context) {
        this.font = context.font();
        this.entityRenderDispatcher = context.entityRenderer();
    }

    public TeleporterRenderState createRenderState() {
        return new TeleporterRenderState();
    }

    public void extractRenderState(TeleporterBlockEntity blockEntity, TeleporterRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.name = blockEntity.hasCrystal() && blockEntity.getCrystal().has(DataComponents.CUSTOM_NAME) ? blockEntity.getCrystal().getHoverName() : null;
    }

    public void submit(TeleporterRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        if (!SimpleTeleportersConfig.CLIENT.disableNameplate.getAsBoolean() && renderState.name != null) {
            Component displayName = renderState.name;
            poseStack.pushPose();
            poseStack.translate(0.5f, 2.0f, 0.5f);
            poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.camera.rotation());
            poseStack.scale(0.025f, -0.025f, 0.025f);
            float f1 = -this.font.width((FormattedText)displayName) / 2;
            float backgroundOpacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int backgroundColor = (int)(backgroundOpacity * 255.0f) << 24;
            nodeCollector.submitText(poseStack, f1, 0.0f, displayName.getVisualOrderText(), false, Font.DisplayMode.POLYGON_OFFSET, renderState.lightCoords, ARGB.opaque((int)-1), backgroundColor, 0);
            poseStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(TeleporterBlockEntity blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity);
    }
}

