/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.item;

import com.mrbysco.simpleteleporters.item.TeleportCrystalItem;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public class EnhancedTeleportCrystalItem
extends TeleportCrystalItem {
    public EnhancedTeleportCrystalItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        MutableComponent enhanced = Component.translatable((String)"text.simpleteleporters.enhanced");
        enhanced.setStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)enhanced);
        if (!stack.has(SimpleTeleportersComponents.GLOBAL_POS)) {
            MutableComponent unlinked = Component.translatable((String)"text.simpleteleporters.unlinked");
            unlinked.setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
            tooltip.add((Component)unlinked);
            MutableComponent sneakKey = Component.literal((String)"Sneak");
            MutableComponent useKey = Component.literal((String)"Right Click");
            if (FMLEnvironment.getDist() == Dist.CLIENT) {
                sneakKey = Component.keybind((String)Minecraft.getInstance().options.keyShift.getName());
                useKey = Component.keybind((String)Minecraft.getInstance().options.keyUse.getName());
            }
            MutableComponent info = Component.translatable((String)"text.simpleteleporters.how_to_link", (Object[])new Object[]{sneakKey, useKey});
            info.setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE));
            tooltip.add((Component)info);
        } else {
            GlobalPos globalPos = (GlobalPos)stack.get(SimpleTeleportersComponents.GLOBAL_POS);
            BlockPos pos = globalPos.pos();
            ResourceKey dimension = globalPos.dimension();
            MutableComponent dimensionName = Component.translatable((String)dimension.location().toLanguageKey("dimension"));
            MutableComponent component = Component.translatable((String)"text.simpleteleporters.linked", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ(), dimensionName});
            component.setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
            tooltip.add((Component)component);
        }
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }
}

