/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.item;

import com.mrbysco.simpleteleporters.registry.SimpleTeleportersAttachments;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlocks;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersComponents;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersSoundEvents;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;

public class HearthCrystalItem
extends Item {
    private static final int TELEPORT_DELAY_TICKS = 60;
    public static final int MAX_CHARGES = 20;

    public HearthCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public static int getCharges(ItemStack stack) {
        return (Integer)stack.getOrDefault(SimpleTeleportersComponents.CHARGES, (Object)20);
    }

    public static void setCharges(ItemStack stack, int charges) {
        stack.set(SimpleTeleportersComponents.CHARGES, (Object)Mth.clamp((int)charges, (int)0, (int)20));
    }

    public static void consumeCharge(ItemStack stack) {
        HearthCrystalItem.setCharges(stack, HearthCrystalItem.getCharges(stack) - 1);
    }

    public boolean isBarVisible(ItemStack stack) {
        return HearthCrystalItem.getCharges(stack) < 20;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)HearthCrystalItem.getCharges(stack) / 20.0f);
    }

    public int getBarColor(ItemStack stack) {
        float ratio = (float)HearthCrystalItem.getCharges(stack) / 20.0f;
        return Mth.hsvToRgb((float)(ratio / 3.0f), (float)1.0f, (float)1.0f);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos clickedPos = context.getClickedPos();
        BlockPos targetPos = level.getBlockState(clickedPos).getCollisionShape((BlockGetter)level, clickedPos).isEmpty() ? clickedPos : (level.getBlockState(clickedPos).is((Block)SimpleTeleportersBlocks.TELEPORTER.get()) ? clickedPos.above() : clickedPos.relative(context.getClickedFace()));
        GlobalPos globalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)targetPos);
        SimpleTeleportersAttachments.HearthData currentData = (SimpleTeleportersAttachments.HearthData)player.getData(SimpleTeleportersAttachments.HEARTH_DATA);
        player.setData(SimpleTeleportersAttachments.HEARTH_DATA, (Object)currentData.withBoundLocation(globalPos));
        String dimensionName = level.dimension().location().toString();
        player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.hearth_info", (Object[])new Object[]{targetPos.getX(), targetPos.getY(), targetPos.getZ(), dimensionName}), true);
        player.playSound((SoundEvent)SimpleTeleportersSoundEvents.ENDER_SHARD_LINK.get(), 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        SimpleTeleportersAttachments.HearthData hearthData = (SimpleTeleportersAttachments.HearthData)player.getData(SimpleTeleportersAttachments.HEARTH_DATA);
        if (hearthData.isTeleporting()) {
            player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.hearth_already_teleporting").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (!hearthData.hasBoundLocation()) {
            player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.invalid_hearth_target").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (HearthCrystalItem.getCharges(stack) <= 0) {
            player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.hearth_no_charges").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        player.setData(SimpleTeleportersAttachments.HEARTH_DATA, (Object)hearthData.withTeleportTimer(60));
        player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.hearth_teleporting").withStyle(ChatFormatting.GOLD), true);
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        SimpleTeleportersAttachments.HearthData hearthData = (SimpleTeleportersAttachments.HearthData)player.getData(SimpleTeleportersAttachments.HEARTH_DATA);
        if (!hearthData.isTeleporting()) {
            return;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (!(mainHandItem.getItem() instanceof HearthCrystalItem)) {
            player.setData(SimpleTeleportersAttachments.HEARTH_DATA, (Object)hearthData.withTeleportTimer(0));
            player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.hearth_cancelled").withStyle(ChatFormatting.RED), true);
            return;
        }
        int timer = hearthData.teleportTimer();
        if (timer > 1) {
            player.setData(SimpleTeleportersAttachments.HEARTH_DATA, (Object)hearthData.withTeleportTimer(timer - 1));
            return;
        }
        player.setData(SimpleTeleportersAttachments.HEARTH_DATA, (Object)hearthData.withTeleportTimer(0));
        if (!hearthData.hasBoundLocation()) {
            return;
        }
        GlobalPos globalPos = hearthData.boundLocation().get();
        BlockPos targetPos = globalPos.pos();
        ResourceKey targetDimension = globalPos.dimension();
        double destX = (double)targetPos.getX() + 0.5;
        double destY = targetPos.getY();
        double destZ = (double)targetPos.getZ() + 0.5;
        MinecraftServer server = level.getServer();
        if (server == null) {
            return;
        }
        if (!level.dimension().equals(targetDimension)) {
            ServerLevel destinationLevel = server.getLevel(targetDimension);
            if (destinationLevel != null) {
                player.teleportTo(destinationLevel, destX, destY, destZ, Set.of(), player.getYRot(), player.getXRot(), true);
            }
        } else {
            player.teleportTo(destX, destY, destZ);
        }
        player.fallDistance = 0.0;
        player.playSound((SoundEvent)SimpleTeleportersSoundEvents.TELEPORTER_TELEPORT.get(), 1.0f, 1.0f);
        HearthCrystalItem.consumeCharge(mainHandItem);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        int charges = HearthCrystalItem.getCharges(stack);
        ChatFormatting chargeColor = charges > 5 ? ChatFormatting.GREEN : (charges > 0 ? ChatFormatting.YELLOW : ChatFormatting.RED);
        MutableComponent chargesInfo = Component.translatable((String)"text.simpleteleporters.hearth_charges", (Object[])new Object[]{charges, 20});
        chargesInfo.setStyle(Style.EMPTY.withColor(chargeColor));
        tooltip.add((Component)chargesInfo);
        MutableComponent sneakKey = Component.literal((String)"Sneak");
        MutableComponent useKey = Component.literal((String)"Right Click");
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            sneakKey = Component.keybind((String)Minecraft.getInstance().options.keyShift.getName());
            useKey = Component.keybind((String)Minecraft.getInstance().options.keyUse.getName());
        }
        MutableComponent bindInfo = Component.translatable((String)"text.simpleteleporters.hearth_bind_hint", (Object[])new Object[]{sneakKey, useKey});
        bindInfo.setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE));
        tooltip.add((Component)bindInfo);
        MutableComponent useInfo = Component.translatable((String)"text.simpleteleporters.hearth_use_hint", (Object[])new Object[]{useKey});
        useInfo.setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
        tooltip.add((Component)useInfo);
        MutableComponent repairInfo = Component.translatable((String)"text.simpleteleporters.hearth_repair_hint");
        repairInfo.setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
        tooltip.add((Component)repairInfo);
    }
}

