/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.block.entity;

import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlockEntities;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersComponents;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TeleporterBlockEntity
extends BlockEntity {
    private ItemStack crystal = ItemStack.EMPTY;
    private int cooldown = 0;
    private DyeColor color = DyeColor.WHITE;
    private boolean powered = false;

    public TeleporterBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleTeleportersBlockEntities.TELEPORTER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TeleporterBlockEntity teleporter) {
        if (teleporter.isCoolingDown()) {
            teleporter.incrementCooldown();
        }
    }

    public boolean hasCrystal() {
        return !this.getCrystal().isEmpty();
    }

    public boolean isInDimension(Entity entity) {
        if (this.getCrystal().isEmpty()) {
            return false;
        }
        if (this.hasEnhancedCrystal()) {
            return true;
        }
        GlobalPos globalPos = (GlobalPos)this.getCrystal().get(SimpleTeleportersComponents.GLOBAL_POS);
        ResourceKey dimensionKey = globalPos != null ? globalPos.dimension() : Level.OVERWORLD;
        return dimensionKey.equals(entity.level().dimension());
    }

    public boolean hasEnhancedCrystal() {
        return !this.getCrystal().isEmpty() && this.getCrystal().is((Item)SimpleTeleportersItems.ENHANCED_ENDER_SHARD.get());
    }

    public ItemStack getCrystal() {
        return this.crystal;
    }

    public void setCrystal(ItemStack crystal) {
        this.crystal = crystal;
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public BlockPos getTeleportPos() {
        if (!this.hasCrystal()) {
            return null;
        }
        GlobalPos globalPos = (GlobalPos)this.getCrystal().get(SimpleTeleportersComponents.GLOBAL_POS);
        return globalPos != null ? globalPos.pos() : null;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.crystal = tag.contains("crystal") ? ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("crystal")) : ItemStack.EMPTY;
        this.cooldown = tag.contains("cooldown") ? tag.getInt("cooldown") : 0;
        this.color = tag.contains("color") ? DyeColor.byId((int)tag.getInt("color")) : DyeColor.WHITE;
        this.powered = tag.getBoolean("powered");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.crystal.isEmpty()) {
            tag.put("crystal", this.crystal.save(registries, (Tag)new CompoundTag()));
        }
        tag.putInt("cooldown", this.cooldown);
        tag.putInt("color", this.color.getId());
        tag.putBoolean("powered", this.powered);
    }

    public boolean isCoolingDown() {
        return this.getCooldown() > 0;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void incrementCooldown() {
        this.setCooldown(this.getCooldown() - 1);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor color) {
        this.color = color;
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public boolean wasPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        DyeColor oldColor = this.color;
        ItemStack oldCrystal = this.crystal;
        super.onDataPacket(net, pkt, registries);
        if (this.level != null && this.level.isClientSide() && (oldColor != this.color || !ItemStack.matches((ItemStack)oldCrystal, (ItemStack)this.crystal))) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        DyeColor oldColor = this.color;
        ItemStack oldCrystal = this.crystal;
        this.loadAdditional(tag, registries);
        if (this.level != null && this.level.isClientSide() && (oldColor != this.color || !ItemStack.matches((ItemStack)oldCrystal, (ItemStack)this.crystal))) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
        }
    }
}

