/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.simpleteleporters.block.entity.TeleporterBlockEntity;
import com.mrbysco.simpleteleporters.config.SimpleTeleportersConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class TeleporterBER
implements BlockEntityRenderer<TeleporterBlockEntity> {
    private final Font font;
    private final EntityRenderDispatcher entityRenderDispatcher;

    public TeleporterBER(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
        this.entityRenderDispatcher = context.getEntityRenderer();
    }

    public void render(TeleporterBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack crystalStack;
        if (!SimpleTeleportersConfig.CLIENT.disableNameplate.getAsBoolean() && blockEntity.hasCrystal() && (crystalStack = blockEntity.getCrystal()).has(DataComponents.CUSTOM_NAME)) {
            Component displayName = crystalStack.getHoverName();
            poseStack.pushPose();
            poseStack.translate(0.5f, 2.0f, 0.5f);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.scale(0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.last().pose();
            float f1 = -this.font.width((FormattedText)displayName) / 2;
            float backgroundOpacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int backgroundColor = (int)(backgroundOpacity * 255.0f) << 24;
            this.font.drawInBatch(displayName, f1, 0.0f, FastColor.ARGB32.opaque((int)-1), false, matrix4f, bufferSource, Font.DisplayMode.SEE_THROUGH, backgroundColor, packedLight);
            poseStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(TeleporterBlockEntity blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity);
    }
}

