/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.datagen.assets;

import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlocks;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersItems;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersSoundEvents;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class SimpleLanguageProvider
extends LanguageProvider {
    public SimpleLanguageProvider(PackOutput packOutput) {
        super(packOutput, "simpleteleporters", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.simpleteleporters", "Simple Teleporters");
        this.addItem((Supplier)SimpleTeleportersItems.ENDER_SHARD, "Ender Shard");
        this.addItem((Supplier)SimpleTeleportersItems.ENHANCED_ENDER_SHARD, "Enhanced Ender Shard");
        this.addItem((Supplier)SimpleTeleportersItems.HEARTH_CRYSTAL, "Hearth Crystal");
        this.addBlock((Supplier)SimpleTeleportersBlocks.TELEPORTER, "Teleporter");
        this.addSubtitle(SimpleTeleportersSoundEvents.TELEPORTER_TELEPORT, "Teleporter teleports");
        this.addSubtitle(SimpleTeleportersSoundEvents.TELEPORTER_CRYSTAL_INSERTED, "Ender Shard inserted");
        this.addSubtitle(SimpleTeleportersSoundEvents.TELEPORTER_CRYSTAL_REMOVED, "Ender Shard removed");
        this.addSubtitle(SimpleTeleportersSoundEvents.ENDER_SHARD_LINK, "Ender Shard link established");
        this.add("text.simpleteleporters.unlinked", "Unlinked");
        this.add("text.simpleteleporters.how_to_link_hearth", "%1$s + %2$s on a block to link a position");
        this.add("text.simpleteleporters.invalid_hearth_target", "Invalid Hearth Crystal target!");
        this.add("text.simpleteleporters.linked_hearth", "Linked Hearth Crystal to %1$s, %2$s, %3$s in %4$s");
        this.add("text.simpleteleporters.linked", "Linked, %1$s, %2$s, %3$s in %4$s");
        this.add("text.simpleteleporters.how_to_link", "%1$s + %2$s on a block to link a position");
        this.add("text.simpleteleporters.hearth_info", "Linked Hearth Crystal to %1$s, %2$s, %3$s in %4$s");
        this.add("text.simpleteleporters.hearth_teleporting", "Teleporting in 3 seconds...");
        this.add("text.simpleteleporters.hearth_countdown", "Teleporting in %1$s seconds...");
        this.add("text.simpleteleporters.hearth_cancelled", "Teleport cancelled!");
        this.add("text.simpleteleporters.hearth_already_teleporting", "Already teleporting!");
        this.add("text.simpleteleporters.hearth_bind_hint", "%1$s + %2$s on a block to set your hearth location");
        this.add("text.simpleteleporters.hearth_use_hint", "%1$s to teleport to your hearth location");
        this.add("text.simpleteleporters.crystal_info", "Linked Ender Shard to %1$s, %2$s, %3$s in %4$s");
        this.add("text.simpleteleporters.error.no_crystal", "This teleporter doesn't have an Ender Shard!");
        this.add("text.simpleteleporters.error.unlinked_teleporter", "This teleporter's Ender Shard is unlinked!");
        this.add("text.simpleteleporters.error.unlinked_shard", "This Ender Shard is unlinked!");
        this.add("text.simpleteleporters.error.invalid_position", "Teleport position is invalid! Perhaps there's a block in the way?");
        this.add("text.simpleteleporters.error.wrong_dimension", "This teleporter's Ender Shard isn't powerful enough to cross dimensions!");
        this.add("text.simpleteleporters.enhanced", "Cross-Dimensional");
        this.addConfig("client", "Client", "Client Settings");
        this.addConfig("disableParticles", "Disable Particles", "Disable the particles shown above an active teleporter");
        this.addConfig("disableNameplate", "Disable Nameplate", "Disable the nameplate shown above a teleporter with a named crystal");
        this.add("item.simpleteleporters.guide_book", "Simple Teleporters Guide");
        this.add("item.simpleteleporters.guide_book.tooltip", "Learn about teleportation");
    }

    public void addSubtitle(DeferredHolder<SoundEvent, SoundEvent> sound, String name) {
        String path = "simpleteleporters" + sound.getId().getPath() + ".subtitle.";
        this.add(path, name);
    }

    private void addConfig(String path, String name, @Nullable String description) {
        this.add("simpleteleporters.configuration." + path, name);
        if (description != null && !description.isEmpty()) {
            this.add("simpleteleporters.configuration." + path + ".tooltip", description);
        }
    }
}

