/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class SimpleTeleportersAttachments {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"simpleteleporters");
    public static final Supplier<AttachmentType<HearthData>> HEARTH_DATA = ATTACHMENT_TYPES.register("hearth_data", () -> AttachmentType.builder(() -> HearthData.DEFAULT).serialize(HearthData.CODEC).copyOnDeath().build());

    public record HearthData(Optional<GlobalPos> boundLocation, int teleportTimer) {
        public static final HearthData DEFAULT = new HearthData(Optional.empty(), 0);
        public static final Codec<HearthData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.optionalFieldOf("bound_location").forGetter(HearthData::boundLocation), (App)Codec.INT.fieldOf("teleport_timer").forGetter(HearthData::teleportTimer)).apply((Applicative)instance, HearthData::new));

        public HearthData withBoundLocation(GlobalPos pos) {
            return new HearthData(Optional.ofNullable(pos), this.teleportTimer);
        }

        public HearthData withTeleportTimer(int timer) {
            return new HearthData(this.boundLocation, timer);
        }

        public boolean hasBoundLocation() {
            return this.boundLocation.isPresent();
        }

        public boolean isTeleporting() {
            return this.teleportTimer > 0;
        }
    }
}

