/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.block.entity;

import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlockEntities;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersComponents;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class TeleporterBlockEntity
extends BlockEntity {
    private ItemStack crystal = ItemStack.EMPTY;
    private int cooldown = 0;

    public TeleporterBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleTeleportersBlockEntities.TELEPORTER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TeleporterBlockEntity teleporter) {
        if (teleporter.isCoolingDown()) {
            teleporter.incrementCooldown();
        }
    }

    public boolean hasCrystal() {
        return !this.getCrystal().isEmpty();
    }

    public boolean isInDimension(Entity entity) {
        if (this.getCrystal().isEmpty()) {
            return false;
        }
        GlobalPos globalPos = (GlobalPos)this.getCrystal().get(SimpleTeleportersComponents.GLOBAL_POS);
        ResourceKey dimensionKey = globalPos != null ? globalPos.dimension() : Level.OVERWORLD;
        return dimensionKey.equals(entity.level().dimension());
    }

    public ItemStack getCrystal() {
        return this.crystal;
    }

    public void setCrystal(ItemStack crystal) {
        this.crystal = crystal;
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public BlockPos getTeleportPos() {
        if (!this.hasCrystal()) {
            return null;
        }
        GlobalPos globalPos = (GlobalPos)this.getCrystal().get(SimpleTeleportersComponents.GLOBAL_POS);
        return globalPos != null ? globalPos.pos() : null;
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        Optional optionalCrystal = input.read("crystal", ItemStack.OPTIONAL_CODEC);
        optionalCrystal.ifPresent(this::setCrystal);
        this.setCooldown(input.getIntOr("cooldown", 0));
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (!this.crystal.isEmpty()) {
            output.store("crystal", ItemStack.CODEC, (Object)this.crystal);
        }
        output.putInt("cooldown", this.cooldown);
    }

    public boolean isCoolingDown() {
        return this.getCooldown() > 0;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void incrementCooldown() {
        this.setCooldown(this.getCooldown() - 1);
    }
}

