/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.client;

import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlocks;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersComponents;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientHandler {
    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent.AfterTranslucentBlocks event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        ClientLevel level = minecraft.level;
        if (player != null && level != null) {
            RandomSource random = level.getRandom();
            for (InteractionHand hand : InteractionHand.values()) {
                BlockPos telePos;
                ItemStack stack = player.getItemInHand(hand);
                if (stack.isEmpty() || !stack.is((Item)SimpleTeleportersItems.ENDER_SHARD.get()) || !stack.has(SimpleTeleportersComponents.GLOBAL_POS)) continue;
                GlobalPos globalPos = (GlobalPos)stack.get(SimpleTeleportersComponents.GLOBAL_POS);
                assert (globalPos != null);
                ResourceKey dimension = globalPos.dimension();
                if (!level.dimension().equals(dimension) || (telePos = globalPos.pos()) == null) continue;
                BlockPos downPos = telePos.below();
                if (level.getBlockState(downPos).is((Block)SimpleTeleportersBlocks.TELEPORTER.get())) {
                    telePos = downPos;
                }
                if (player.blockPosition().distManhattan((Vec3i)telePos) >= 15) continue;
                level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, random.triangle((double)telePos.getX() + 0.5, 0.2), random.triangle((double)telePos.getY() + 0.5, 0.2), random.triangle((double)telePos.getZ() + 0.5, 0.2), 0.0, 0.0, 0.0);
            }
        }
    }
}

