/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.item;

import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlocks;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersComponents;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersSoundEvents;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

public class TeleportCrystalItem
extends Item {
    public TeleportCrystalItem(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.isSecondaryUseActive()) {
            BlockPos pos;
            Player player = ctx.getPlayer();
            ItemStack stack = ctx.getItemInHand().split(1);
            Level level = ctx.getLevel();
            BlockPos offsetPos = level.getBlockState(pos = ctx.getClickedPos()).getCollisionShape((BlockGetter)level, pos).isEmpty() ? pos : (level.getBlockState(pos).is((Block)SimpleTeleportersBlocks.TELEPORTER.get()) ? pos.above() : pos.relative(ctx.getClickedFace()));
            stack.set(SimpleTeleportersComponents.GLOBAL_POS, (Object)GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)offsetPos));
            String dimensionName = player.level().dimension().location().toString();
            if (!player.addItem(stack)) {
                player.drop(stack, false);
            }
            MutableComponent msg = Component.translatable((String)"text.simpleteleporters.crystal_info", (Object[])new Object[]{offsetPos.getX(), offsetPos.getY(), offsetPos.getZ(), dimensionName});
            msg.setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
            player.displayClientMessage((Component)msg, true);
            player.playSound((SoundEvent)SimpleTeleportersSoundEvents.ENDER_SHARD_LINK.get(), 0.5f, 0.4f / (ctx.getLevel().getRandom().nextFloat() * 0.4f + 0.8f));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        if (!stack.has(SimpleTeleportersComponents.GLOBAL_POS)) {
            MutableComponent unlinked = Component.translatable((String)"text.simpleteleporters.unlinked");
            unlinked.setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
            tooltipAdder.accept((Component)unlinked);
            MutableComponent sneakKey = Component.literal((String)"Sneak");
            MutableComponent useKey = Component.literal((String)"Right Click");
            if (FMLEnvironment.getDist().isClient()) {
                sneakKey = Component.keybind((String)Minecraft.getInstance().options.keyShift.getName());
                useKey = Component.keybind((String)Minecraft.getInstance().options.keyUse.getName());
            }
            MutableComponent info = Component.translatable((String)"text.simpleteleporters.how_to_link", (Object[])new Object[]{sneakKey, useKey});
            info.setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE));
            tooltipAdder.accept((Component)info);
        } else {
            GlobalPos globalPos = (GlobalPos)stack.get(SimpleTeleportersComponents.GLOBAL_POS);
            BlockPos pos = globalPos.pos();
            ResourceKey dimension = globalPos.dimension();
            MutableComponent component = Component.translatable((String)"text.simpleteleporters.linked", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ(), dimension.location()});
            component.setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
            tooltipAdder.accept((Component)component);
        }
    }
}

