/*
 * Decompiled with CFR 0.152.
 */
package com.akselglyholt.squaremapsimpleclans.hook;

import com.akselglyholt.squaremapsimpleclans.ClanMap;
import com.akselglyholt.squaremapsimpleclans.hook.SimpleClansHook;
import com.akselglyholt.squaremapsimpleclans.task.SquaremapTask;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.bukkit.plugin.Plugin;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.WorldIdentifier;

public final class SquaremapHook {
    public static final Key CLAN_BASE_KEY = Key.of((String)"clanhome");
    public static final Key CLAN_BASE_LAYER_KEY = Key.of((String)"clans");
    private final Map<WorldIdentifier, SquaremapTask> tasks = new HashMap<WorldIdentifier, SquaremapTask>();

    public SquaremapHook(ClanMap plugin, SimpleClansHook simpleClansHook) {
        try {
            BufferedImage image = ImageIO.read(new File(plugin.getDataFolder(), "clanhome.png"));
            SquaremapProvider.get().iconRegistry().register(CLAN_BASE_KEY, (Object)image);
        }
        catch (Exception e) {
            plugin.getLogger().severe("Failed to load image from resources folder: " + e.getMessage());
            return;
        }
        for (MapWorld world : SquaremapProvider.get().mapWorlds()) {
            SimpleLayerProvider provider = SimpleLayerProvider.builder((String)"Clan Bases").defaultHidden(false).showControls(true).layerPriority(99).zIndex(1000).build();
            world.layerRegistry().register(CLAN_BASE_LAYER_KEY, (Object)provider);
            SquaremapTask task = new SquaremapTask(plugin, world, provider, simpleClansHook);
            task.runTaskTimerAsynchronously((Plugin)plugin, 20L, 6000L);
            this.tasks.put(world.identifier(), task);
        }
    }

    public void disable() {
        this.tasks.values().forEach(SquaremapTask::disable);
        this.tasks.clear();
    }
}

