/*
 * Decompiled with CFR 0.152.
 */
package com.akselglyholt.squaremapsimpleclans.task;

import com.akselglyholt.squaremapsimpleclans.ClanMap;
import java.util.UUID;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.jpenilla.squaremap.api.SquaremapProvider;

public final class HideWarringClansTask
extends BukkitRunnable {
    private final ClanMap plugin;
    private boolean stop;

    public HideWarringClansTask(ClanMap plugin) {
        this.plugin = plugin;
    }

    public void run() {
        if (this.stop) {
            this.cancel();
        }
        this.updatePlayers();
    }

    void updatePlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID uuid = player.getUniqueId();
            ClanPlayer clanPlayer = SimpleClans.getInstance().getClanManager().getClanPlayer(player);
            if (clanPlayer == null || clanPlayer.getClan().getWarringClans().isEmpty()) continue;
            boolean hide = SquaremapProvider.get().playerManager().hidden(uuid);
            this.plugin.getLogger().info("Hiding " + player.getName() + " from map: " + hide);
            if (hide && !SquaremapProvider.get().playerManager().hidden(uuid)) {
                SquaremapProvider.get().playerManager().hide(uuid);
                continue;
            }
            if (hide || !SquaremapProvider.get().playerManager().hidden(uuid)) continue;
            SquaremapProvider.get().playerManager().show(uuid);
        }
    }

    public void disable() {
        this.cancel();
        this.stop = true;
    }
}

