/*
 * Decompiled with CFR 0.152.
 */
package com.akselglyholt.squaremapsimpleclans.task;

import com.akselglyholt.squaremapsimpleclans.ClanMap;
import com.akselglyholt.squaremapsimpleclans.hook.SimpleClansHook;
import com.akselglyholt.squaremapsimpleclans.hook.SquaremapHook;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public final class SquaremapTask
extends BukkitRunnable {
    private final World bukkitWorld;
    private final SimpleLayerProvider provider;
    private final ClanMap plugin;
    private final SimpleClansHook simpleClansHook;
    private boolean stop;

    public SquaremapTask(ClanMap plugin, MapWorld world, SimpleLayerProvider provider, SimpleClansHook simpleClansHook) {
        this.plugin = plugin;
        this.bukkitWorld = BukkitAdapter.bukkitWorld((MapWorld)world);
        this.provider = provider;
        this.simpleClansHook = simpleClansHook;
    }

    public void run() {
        if (this.stop) {
            this.cancel();
        }
        this.updateBases();
    }

    void updateBases() {
        this.provider.clearMarkers();
        SimpleClans simpleClans = this.simpleClansHook.getSimpleClans();
        Clan[] clans = simpleClans.getClanManager().getClans().toArray(new Clan[0]);
        if (clans.length == 0) {
            return;
        }
        for (Clan clan : clans) {
            Location homeLocation = clan.getHomeLocation();
            if (homeLocation == null || homeLocation.getWorld() != this.bukkitWorld) continue;
            Point homePoint = Point.of((double)homeLocation.getX(), (double)homeLocation.getZ());
            try {
                Key imageKey = Key.of((String)SquaremapHook.CLAN_BASE_KEY.toString());
                Icon iconMarker = Marker.icon((Point)homePoint, (Key)imageKey, (int)32, (int)32);
                if (iconMarker != null) {
                    iconMarker.markerOptions(MarkerOptions.builder().hoverTooltip(clan.getName() + " [" + clan.getTag() + "]'s base").build());
                    this.provider.addMarker(imageKey, (Marker)iconMarker);
                    continue;
                }
                this.plugin.getLogger().warning("Failed to create icon for " + clan.getTag());
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load image for clan " + clan.getTag() + ": " + e.getMessage());
            }
        }
    }

    public void disable() {
        this.cancel();
        this.stop = true;
        this.provider.clearMarkers();
    }
}

