/*
 * Decompiled with CFR 0.152.
 */
package de.knabbiii.spawnelytra.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.KeybindComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SpawnBoostListener
extends BukkitRunnable
implements Listener {
    private final Plugin plugin;
    private final int multiplyValue;
    private final int spawnRadius;
    private final boolean boostEnabled;
    private final World world;
    private final List<Player> flying = new ArrayList<Player>();
    private final List<Player> boosted = new ArrayList<Player>();
    private final String message;

    public static SpawnBoostListener create(Plugin plugin) {
        FileConfiguration config = plugin.getConfig();
        if (!(config.contains("multiplyValue") && config.contains("spawnRadius") && config.contains("boostEnabled") && config.contains("world") && config.contains("message"))) {
            plugin.saveResource("config.yml", true);
            plugin.reloadConfig();
        }
        return new SpawnBoostListener(plugin, config.getInt("multiplyValue"), config.getInt("spawnRadius"), config.getBoolean("boostEnabled"), Objects.requireNonNull(Bukkit.getWorld((String)config.getString("world")), "Invalid world " + config.getString("world")), config.getString("message"));
    }

    private SpawnBoostListener(Plugin plugin, int multiplyValue, int spawnRadius, boolean boostEnabled, World world, String message) {
        this.plugin = plugin;
        this.multiplyValue = multiplyValue;
        this.spawnRadius = spawnRadius;
        this.boostEnabled = boostEnabled;
        this.world = world;
        this.message = message;
        this.runTaskTimer(this.plugin, 0L, 3L);
    }

    public void run() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
                return;
            }
            boolean inSpawnRadius = this.isInSpawnRadius((Player)player);
            boolean isCurrentlyFlying = this.flying.contains(player);
            if (isCurrentlyFlying) {
                player.setAllowFlight(false);
            } else {
                player.setAllowFlight(inSpawnRadius);
            }
            if (isCurrentlyFlying && !player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isAir()) {
                player.setAllowFlight(false);
                player.setGliding(false);
                this.boosted.remove(player);
                Bukkit.getScheduler().runTaskLater(this.plugin, () -> this.flying.remove(player), 5L);
            }
        });
    }

    @EventHandler
    public void onDoubleJump(PlayerToggleFlightEvent event) {
        if (event.getPlayer().getGameMode() != GameMode.SURVIVAL && event.getPlayer().getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (!this.isInSpawnRadius(event.getPlayer())) {
            return;
        }
        if (this.flying.contains(event.getPlayer())) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        event.getPlayer().setGliding(true);
        this.flying.add(event.getPlayer());
        if (!this.boostEnabled) {
            return;
        }
        String[] messageParts = this.message.split("%key%");
        try {
            BaseComponent[] components = new ComponentBuilder(messageParts[0]).append((BaseComponent)new KeybindComponent("key.swapOffhand")).append(messageParts[1]).create();
            event.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
        }
        catch (Exception e) {
            event.getPlayer().sendMessage(this.message.replace("%key%", "[F]"));
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && (event.getCause() == EntityDamageEvent.DamageCause.FALL || event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) && this.flying.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSwapItem(PlayerSwapHandItemsEvent event) {
        if (!this.boostEnabled || !this.flying.contains(event.getPlayer()) || this.boosted.contains(event.getPlayer())) {
            return;
        }
        event.setCancelled(true);
        this.boosted.add(event.getPlayer());
        event.getPlayer().setVelocity(event.getPlayer().getLocation().getDirection().multiply(this.multiplyValue));
    }

    @EventHandler
    public void onToggleGlide(EntityToggleGlideEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && this.flying.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.flying.contains(player)) {
            player.setAllowFlight(false);
            player.setGliding(false);
            this.flying.remove(player);
            this.boosted.remove(player);
        }
    }

    private boolean isInSpawnRadius(Player player) {
        if (!player.getWorld().equals((Object)this.world)) {
            return false;
        }
        return player.getWorld().getSpawnLocation().distance(player.getLocation()) <= (double)this.spawnRadius;
    }
}

