/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.blockhistory.v3;

import de.shiewk.blockhistory.v3.HistoryManager;
import de.shiewk.blockhistory.v3.StatManager;
import de.shiewk.blockhistory.v3.command.BlockHistoryCommand;
import de.shiewk.blockhistory.v3.listener.BlockListener;
import de.shiewk.blockhistory.v3.util.SchedulerUtil;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class BlockHistoryPlugin
extends JavaPlugin {
    public static final boolean isFolia;
    private static ComponentLogger LOGGER;
    private static BlockHistoryPlugin INSTANCE;
    public static final TextColor COLOR_PRIMARY;
    public static final TextColor COLOR_SECONDARY;
    public static final TextColor COLOR_FAIL;
    public static final Component CHAT_PREFIX;
    private HistoryManager historyManager;
    private StatManager statManager;

    public void onLoad() {
        INSTANCE = this;
        LOGGER = this.getComponentLogger();
    }

    public void onEnable() {
        LOGGER.info("Folia: {}", (Object)(isFolia ? "yes" : "no"));
        this.statManager = new StatManager();
        Path saveDirectory = Path.of(this.getDataFolder().getPath(), "history");
        try {
            Files.createDirectories(saveDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.historyManager = new HistoryManager((Logger)LOGGER, saveDirectory, this.statManager);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, this::registerCommands);
        SchedulerUtil.scheduleGlobalRepeating((Plugin)this, BlockListener::clearCache, 6000, 6000);
        this.listen(new BlockListener());
    }

    private void registerCommands(@NotNull ReloadableRegistrarEvent<Commands> event) {
        Commands commands = (Commands)event.registrar();
        commands.register(new BlockHistoryCommand().getCommandNode());
    }

    private void listen(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void onDisable() {
        this.historyManager.shutdown();
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public StatManager getStatManager() {
        return this.statManager;
    }

    public static BlockHistoryPlugin instance() {
        return INSTANCE;
    }

    public static ComponentLogger logger() {
        return LOGGER;
    }

    static {
        boolean folia;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            folia = true;
        }
        catch (ClassNotFoundException e) {
            folia = false;
        }
        isFolia = folia;
        LOGGER = null;
        INSTANCE = null;
        COLOR_PRIMARY = TextColor.color((int)16745728);
        COLOR_SECONDARY = TextColor.color((int)0xFF0011);
        COLOR_FAIL = TextColor.color((int)0xCF0000);
        CHAT_PREFIX = Component.text((String)"BlockHistory \u00bb ", (TextColor)COLOR_SECONDARY);
    }
}

