/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.blockhistory.v3;

public final class StatManager {
    private final long startTime = System.nanoTime();
    private long elementsWritten = 0L;
    private long bytesWritten = 0L;

    StatManager() {
    }

    void elementWritten() {
        ++this.elementsWritten;
    }

    void bytesWritten(int bytes) {
        this.bytesWritten += (long)bytes;
    }

    public long getElementsWritten() {
        return this.elementsWritten;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTimeMsSinceStart() {
        return (System.nanoTime() - this.getStartTime()) / 1000000L;
    }

    public long getTimeSecondsSinceStart() {
        return this.getTimeMsSinceStart() / 1000L;
    }

    public float getElementsWrittenPerSecond() {
        return (float)Math.round((float)this.getElementsWritten() / (float)this.getTimeSecondsSinceStart() * 10.0f) / 10.0f;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public float getBytesWrittenPerSecond() {
        return (float)Math.round((float)this.getBytesWritten() / (float)this.getTimeSecondsSinceStart() * 10.0f) / 10.0f;
    }
}

