/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.blockhistory.v3.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.shiewk.blockhistory.v3.BlockHistoryPlugin;
import de.shiewk.blockhistory.v3.StatManager;
import de.shiewk.blockhistory.v3.history.BlockHistoryElement;
import de.shiewk.blockhistory.v3.history.BlockHistorySearchCallback;
import de.shiewk.blockhistory.v3.util.CommandUtil;
import de.shiewk.blockhistory.v3.util.PlayerUtil;
import de.shiewk.blockhistory.v3.util.UnitUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.math.BlockPosition;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public final class BlockHistoryCommand {
    @NotNull
    public LiteralCommandNode<CommandSourceStack> getCommandNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blockhistory").requires(CommandUtil.requirePermission("blockhistory.command.root"))).then(((LiteralArgumentBuilder)Commands.literal((String)"stats").requires(CommandUtil.requirePermission("blockhistory.command.stats"))).executes(this::statsCommand))).then(((LiteralArgumentBuilder)Commands.literal((String)"diskspace").requires(CommandUtil.requirePermission("blockhistory.command.diskspace"))).executes(this::approximateDiskSpace))).then(((LiteralArgumentBuilder)Commands.literal((String)"history").requires(CommandUtil.requirePermission("blockhistory.command.history"))).then(((RequiredArgumentBuilder)Commands.argument((String)"location", (ArgumentType)ArgumentTypes.blockPosition()).executes(this::historyCommand)).then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes(this::historyCommand))))).build();
    }

    private int approximateDiskSpace(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append((Component)Component.text((String)"Approximating disk space usage, please wait... (this could take a while)", (TextColor)BlockHistoryPlugin.COLOR_PRIMARY)));
        try {
            BlockHistoryPlugin.instance().getHistoryManager().approximateDiskSpaceBytes().whenComplete((result, throwable) -> {
                if (throwable != null) {
                    sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append((Component)Component.text((String)"This operation failed, please check the server logs.", (TextColor)BlockHistoryPlugin.COLOR_FAIL)));
                    StringWriter strw = new StringWriter();
                    throwable.printStackTrace(new PrintWriter(strw));
                    BlockHistoryPlugin.logger().warn("Exception while approximating disk space:");
                    for (String s : strw.toString().split("\n")) {
                        BlockHistoryPlugin.logger().warn(s);
                    }
                } else {
                    long bytes = result.getDiskSpaceBytes();
                    long directories = result.getDirectoryCount();
                    long files = result.getFileCount();
                    sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append(((TextComponent)((TextComponent)Component.text((String)"Block history files use approximately ", (TextColor)BlockHistoryPlugin.COLOR_PRIMARY).append((Component)Component.text((String)UnitUtil.formatDataSize(bytes), (TextColor)BlockHistoryPlugin.COLOR_SECONDARY))).append((Component)Component.text((String)" of disk space. "))).append((Component)Component.text((String)"(%s directories with %s files in total)".formatted(directories, files), (TextColor)NamedTextColor.GRAY))));
                }
            });
        }
        catch (RejectedExecutionException e) {
            sender.sendMessage((Component)Component.text((String)"The searching system is currently too busy, please try again later.", (TextColor)BlockHistoryPlugin.COLOR_FAIL));
        }
        return 1;
    }

    private int statsCommand(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        StatManager statManager = BlockHistoryPlugin.instance().getStatManager();
        long millisSinceStart = statManager.getTimeMsSinceStart();
        sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append(((TextComponent)Component.text((String)"The plugin has started up ", (TextColor)BlockHistoryPlugin.COLOR_PRIMARY).append((Component)Component.text((String)UnitUtil.formatTime(millisSinceStart), (TextColor)BlockHistoryPlugin.COLOR_SECONDARY))).append((Component)Component.text((String)" ago."))));
        sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append(((TextComponent)((TextComponent)Component.text((String)"So far, we have written ", (TextColor)BlockHistoryPlugin.COLOR_PRIMARY).append((Component)Component.text((long)statManager.getElementsWritten(), (TextColor)BlockHistoryPlugin.COLOR_SECONDARY))).append((Component)Component.text((String)" history elements to disk. "))).append((Component)Component.text((String)"(%s elements per second)".formatted(Float.valueOf(statManager.getElementsWrittenPerSecond())), (TextColor)NamedTextColor.GRAY))));
        sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append(((TextComponent)((TextComponent)Component.text((String)"These elements have a total size of ", (TextColor)BlockHistoryPlugin.COLOR_PRIMARY).append((Component)Component.text((String)UnitUtil.formatDataSize(statManager.getBytesWritten()), (TextColor)BlockHistoryPlugin.COLOR_SECONDARY))).append((Component)Component.text((String)". "))).append((Component)Component.text((String)"(%s per second)".formatted(UnitUtil.formatDataSize(statManager.getBytesWrittenPerSecond())), (TextColor)NamedTextColor.GRAY))));
        try {
            long usableDiskSpace = BlockHistoryPlugin.instance().getHistoryManager().getUsableDiskSpace();
            sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append(((TextComponent)Component.text((String)"There are ", (TextColor)BlockHistoryPlugin.COLOR_PRIMARY).append((Component)Component.text((String)UnitUtil.formatDataSize(usableDiskSpace), (TextColor)BlockHistoryPlugin.COLOR_SECONDARY))).append((Component)Component.text((String)" of disk space available."))));
        }
        catch (IOException e) {
            sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append((Component)Component.text((String)"Failed to get usable disk space", (TextColor)BlockHistoryPlugin.COLOR_FAIL)));
            StringWriter strw = new StringWriter();
            e.printStackTrace(new PrintWriter(strw));
            BlockHistoryPlugin.logger().warn("Exception while getting usable disk space:");
            for (String s : strw.toString().split("\n")) {
                BlockHistoryPlugin.logger().warn(s);
            }
        }
        return 1;
    }

    private int historyCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        World world;
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        CommandSender sender = stack.getSender();
        BlockPosition blockPosition = (BlockPosition)((BlockPositionResolver)context.getArgument("location", BlockPositionResolver.class)).resolve(stack);
        try {
            world = (World)context.getArgument("world", World.class);
        }
        catch (IllegalArgumentException ignored) {
            world = CommandUtil.getPlayerOf(stack, "You need to provide a world to search").getWorld();
        }
        int blockZ = blockPosition.blockZ();
        int blockY = blockPosition.blockY();
        int blockX = blockPosition.blockX();
        sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append((Component)Component.text((String)"Searching in world %s at x=%s y=%s z=%s, please wait...\n".formatted(world.key(), blockX, blockY, blockZ), (TextColor)BlockHistoryPlugin.COLOR_PRIMARY)));
        try {
            World searchedWorld = world;
            long n = System.nanoTime();
            AtomicInteger foundElements = new AtomicInteger(0);
            BlockHistoryPlugin.instance().getHistoryManager().searchAsync(new BlockHistoryCommandCallback(sender, foundElements), world, blockX, blockY, blockZ).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    StringWriter strw = new StringWriter();
                    throwable.printStackTrace(new PrintWriter(strw));
                    BlockHistoryPlugin.logger().warn("Exception while searching block at world {} x {} y {} z {}:", new Object[]{searchedWorld, blockX, blockY, blockZ});
                    for (String s : strw.toString().split("\n")) {
                        BlockHistoryPlugin.logger().warn(s);
                    }
                    sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append((Component)Component.text((String)"An error occurred while searching, please check the server console.\n", (TextColor)BlockHistoryPlugin.COLOR_FAIL)));
                } else {
                    int elementsFound = foundElements.get();
                    sender.sendMessage((elementsFound > 0 ? Component.newline() : Component.empty()).append(BlockHistoryPlugin.CHAT_PREFIX.append((Component)Component.text((String)"Search completed in %s ms, %s elements found".formatted((System.nanoTime() - n) / 1000000L, elementsFound), (TextColor)BlockHistoryPlugin.COLOR_PRIMARY))));
                }
            });
        }
        catch (RejectedExecutionException e) {
            sender.sendMessage((Component)Component.text((String)"The searching system is currently too busy, please try again later.", (TextColor)BlockHistoryPlugin.COLOR_FAIL));
        }
        return 1;
    }

    private record BlockHistoryCommandCallback(CommandSender sender, AtomicInteger foundElements) implements BlockHistorySearchCallback
    {
        @Override
        public void onElementFound(BlockHistoryElement element) {
            this.sender.sendMessage(BlockHistoryPlugin.CHAT_PREFIX.append(element.toComponent(PlayerUtil::playerName)));
            this.foundElements.getAndIncrement();
        }

        @Override
        public void onNoFilePresent(FileNotFoundException e) {
            BlockHistoryPlugin.logger().info("No file present");
        }
    }
}

