/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.blockhistory.v3.history;

import de.shiewk.blockhistory.v3.BlockHistoryPlugin;
import de.shiewk.blockhistory.v3.history.BlockHistoryType;
import de.shiewk.blockhistory.v3.util.UnitUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockHistoryElement(@NotNull World world, int x, int y, int z, @NotNull BlockHistoryType type, long timestamp, @Nullable UUID player, @NotNull Material material, byte[] additionalData) {
    public static final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1);

    public BlockHistoryElement(@NotNull World world, int x, int y, int z, @NotNull BlockHistoryType type, long timestamp, @Nullable UUID player, @NotNull Material material, byte @Nullable [] additionalData) {
        Objects.requireNonNull(world, "world");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(material, "material");
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
        this.timestamp = timestamp;
        this.player = player;
        this.material = material;
        this.additionalData = Objects.requireNonNullElse(additionalData, new byte[0]);
    }

    public Component toComponent(Function<UUID, Component> playerNameResolver) {
        Component playerName = playerNameResolver.apply(this.player);
        Date date = Date.from(Instant.ofEpochMilli(this.timestamp));
        TextComponent component = (TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Block ", (TextColor)BlockHistoryPlugin.COLOR_PRIMARY).append((Component)Component.translatable((Translatable)this.material, (TextColor)BlockHistoryPlugin.COLOR_SECONDARY))).append((Component)Component.text((String)" was "))).append((Component)Component.text((String)this.type.displayName, (TextColor)BlockHistoryPlugin.COLOR_SECONDARY))).append((Component)Component.text((String)" by "))).append(playerName.colorIfAbsent(BlockHistoryPlugin.COLOR_SECONDARY))).append((Component)Component.text((String)" at "))).append((Component)Component.text((String)dateFormat.format(date)));
        if (this.additionalData.length > 0 && this.type == BlockHistoryType.SIGN) {
            component = (TextComponent)component.append(((TextComponent)Component.text((String)": \"").append(MiniMessage.miniMessage().deserialize((Object)new String(this.additionalData)))).append((Component)Component.text((String)"\"")));
        }
        return component;
    }

    public static BlockHistoryElement read(int dataVersion, DataInputStream dataIn, World world, int chunkX, int chunkZ) throws IOException {
        switch (dataVersion) {
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown data version: " + dataVersion);
            }
        }
        return BlockHistoryElement.readv0(dataIn, world, chunkX, chunkZ);
    }

    private static BlockHistoryElement readv0(DataInputStream dataIn, World world, int chunkX, int chunkZ) throws IOException {
        byte chunkRelativeX = dataIn.readByte();
        int realX = chunkX < 0 ? (chunkX + 1) * 16 - (16 - chunkRelativeX) : chunkX * 16 + chunkRelativeX;
        byte chunkRelativeZ = dataIn.readByte();
        int realZ = chunkZ < 0 ? (chunkZ + 1) * 16 - (16 - chunkRelativeZ) : chunkZ * 16 + chunkRelativeZ;
        int y = dataIn.readInt();
        BlockHistoryType type = BlockHistoryType.values()[dataIn.readInt()];
        long timestamp = dataIn.readLong();
        UUID player = dataIn.readBoolean() ? new UUID(dataIn.readLong(), dataIn.readLong()) : null;
        String materialName = dataIn.readUTF();
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            throw new IllegalStateException("Material " + materialName + " not found");
        }
        int additionalLength = dataIn.readInt();
        byte[] additionalData = additionalLength > 0 ? dataIn.readNBytes(additionalLength) : new byte[]{};
        return new BlockHistoryElement(world, realX, y, realZ, type, timestamp, player, material, additionalData);
    }

    public byte[] saveData() throws IOException {
        ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
        try (DataOutputStream dataOut = new DataOutputStream(arrayOut);){
            dataOut.writeByte(0);
            dataOut.writeByte(UnitUtil.getBlockChunkLocation(this.x));
            dataOut.writeByte(UnitUtil.getBlockChunkLocation(this.z));
            dataOut.writeInt(this.y);
            dataOut.writeInt(this.type.ordinal());
            dataOut.writeLong(this.timestamp);
            boolean writePlayerData = this.player != null;
            dataOut.writeBoolean(writePlayerData);
            if (writePlayerData) {
                dataOut.writeLong(this.player.getMostSignificantBits());
                dataOut.writeLong(this.player.getLeastSignificantBits());
            }
            dataOut.writeUTF(this.material.name());
            dataOut.writeInt(this.additionalData.length);
            dataOut.flush();
        }
        arrayOut.write(this.additionalData);
        arrayOut.flush();
        return arrayOut.toByteArray();
    }

    public Location getLocation() {
        return new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
    }
}

