/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.blockhistory.v3.listener;

import de.shiewk.blockhistory.v3.BlockHistoryPlugin;
import de.shiewk.blockhistory.v3.history.BlockHistoryElement;
import de.shiewk.blockhistory.v3.history.BlockHistoryType;
import de.shiewk.blockhistory.v3.util.SchedulerUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public final class BlockListener
implements Listener {
    private static final Map<UUID, UUID> igniters = BlockHistoryPlugin.isFolia ? new ConcurrentHashMap<UUID, UUID>() : new Object2ObjectOpenHashMap();
    private static final Map<Block, UUID> blocks = BlockHistoryPlugin.isFolia ? new ConcurrentHashMap<Block, UUID>() : new Object2ObjectOpenHashMap();

    public static void clearCache() {
        igniters.clear();
        blocks.clear();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        this.createAndAddEntry(BlockHistoryType.BREAK, event.getPlayer(), block);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        this.createAndAddEntry(BlockHistoryType.PLACE, event.getPlayer(), block);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBucketEmptied(PlayerBucketEmptyEvent event) {
        SchedulerUtil.scheduleGlobal((Plugin)BlockHistoryPlugin.instance(), () -> {
            Block block = event.getBlock();
            this.createAndAddEntry(BlockHistoryType.EMPTY_BUCKET, event.getPlayer(), block);
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBucketFilled(PlayerBucketFillEvent event) {
        Block block = event.getBlock();
        this.createAndAddEntry(BlockHistoryType.FILL_BUCKET, event.getPlayer(), block);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity entity;
        Entity entity2 = entity = event.getEntity();
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TNTPrimed.class, Creeper.class, EnderCrystal.class}, (Object)entity3, n)) {
            case 0: {
                TNTPrimed primed = (TNTPrimed)entity3;
                for (Block block : event.blockList()) {
                    Player player;
                    Entity entity4 = primed.getSource();
                    this.createAndAddEntry(BlockHistoryType.EXPLODE_TNT, entity4 instanceof Player ? (player = (Player)entity4) : null, block);
                }
                break;
            }
            case 1: {
                Creeper creeper = (Creeper)entity3;
                UUID igniter = igniters.remove(creeper.getUniqueId());
                for (Block block : event.blockList()) {
                    this.createAndAddEntry(BlockHistoryType.EXPLODE_CREEPER, igniter, block);
                }
                break;
            }
            case 2: {
                EnderCrystal crystal = (EnderCrystal)entity3;
                UUID igniter = igniters.remove(crystal.getUniqueId());
                for (Block block : event.blockList()) {
                    this.createAndAddEntry(BlockHistoryType.EXPLODE_END_CRYSTAL, igniter, block);
                }
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockExplode(BlockExplodeEvent event) {
        Block explodedBlock = event.getBlock();
        UUID exploder = blocks.remove(explodedBlock);
        BlockHistoryType type = BlockHistoryType.EXPLODE_BLOCK;
        for (Block block : event.blockList()) {
            this.createAndAddEntry(type, exploder, block);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityDamagedByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Entity entity2 = event.getEntity();
            if (entity2 instanceof EnderCrystal) {
                EnderCrystal enderCrystal = (EnderCrystal)entity2;
                igniters.put(enderCrystal.getUniqueId(), player.getUniqueId());
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (event.getPlayer().getEquipment().getItemInMainHand().getAmount() > 0 || event.getPlayer().getEquipment().getItemInOffHand().getAmount() > 0) {
                igniters.put(creeper.getUniqueId(), event.getPlayer().getUniqueId());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            if (clickedBlock.getType() == Material.RESPAWN_ANCHOR) {
                blocks.put(clickedBlock, event.getPlayer().getUniqueId());
            } else {
                BlockData blockData = clickedBlock.getBlockData();
                if (blockData instanceof Bed) {
                    Bed bed = (Bed)blockData;
                    BlockFace facing = bed.getFacing();
                    if (bed.getPart() == Bed.Part.FOOT) {
                        Block actualBlock = new Location(clickedBlock.getWorld(), (double)(clickedBlock.getX() + facing.getModX()), (double)(clickedBlock.getY() + facing.getModY()), (double)(clickedBlock.getZ() + facing.getModZ())).getBlock();
                        if (actualBlock.getBlockData() instanceof Bed) {
                            blocks.put(actualBlock, event.getPlayer().getUniqueId());
                        } else {
                            BlockHistoryPlugin.logger().warn("Error: Bed does not exist");
                        }
                    } else {
                        blocks.put(clickedBlock, event.getPlayer().getUniqueId());
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Location blockLocation = block.getLocation();
        StringBuilder signData = new StringBuilder();
        MiniMessage serializer = MiniMessage.miniMessage();
        for (Component line : event.lines()) {
            if (!signData.isEmpty()) {
                signData.append(" ");
            }
            signData.append((String)serializer.serialize(line));
        }
        this.addEntryToManager(new BlockHistoryElement(block.getWorld(), blockLocation.getBlockX(), blockLocation.getBlockY(), blockLocation.getBlockZ(), BlockHistoryType.SIGN, System.currentTimeMillis(), player.getUniqueId(), block.getType(), signData.toString().getBytes()));
    }

    private void addEntryToManager(BlockHistoryElement element) {
        try {
            BlockHistoryPlugin.instance().getHistoryManager().addHistoryElement(element);
        }
        catch (RejectedExecutionException e) {
            BlockHistoryPlugin.logger().warn("Too many actions are happening at the same time, skipping one");
        }
    }

    private void createAndAddEntry(BlockHistoryType type, Player player, Block block) {
        this.createAndAddEntry(type, player == null ? null : player.getUniqueId(), block);
    }

    private void createAndAddEntry(BlockHistoryType type, UUID player, Block block) {
        this.addEntryToManager(new BlockHistoryElement(block.getWorld(), block.getX(), block.getY(), block.getZ(), type, System.currentTimeMillis(), player, block.getType(), null));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onContainerOpen(PlayerInteractEvent event) {
        Block block;
        if (event.hasBlock() && event.getAction().isRightClick() && (block = event.getClickedBlock()).getState() instanceof Container) {
            this.createAndAddEntry(BlockHistoryType.CHEST_OPEN, event.getPlayer(), block);
        }
    }
}

