/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.blockhistory.v3.util;

import de.shiewk.blockhistory.v3.HistoryManager;
import java.nio.file.Path;
import org.bukkit.Location;
import org.bukkit.World;

public final class BlockHistoryFileNames {
    private BlockHistoryFileNames() {
    }

    private static char base32encode(short i) {
        return switch (i) {
            case 0 -> '0';
            case 1 -> '1';
            case 2 -> '2';
            case 3 -> '3';
            case 4 -> '4';
            case 5 -> '5';
            case 6 -> '6';
            case 7 -> '7';
            case 8 -> '8';
            case 9 -> '9';
            case 10 -> 'a';
            case 11 -> 'b';
            case 12 -> 'c';
            case 13 -> 'd';
            case 14 -> 'e';
            case 15 -> 'f';
            case 16 -> 'g';
            case 17 -> 'h';
            case 18 -> 'i';
            case 19 -> 'j';
            case 20 -> 'k';
            case 21 -> 'l';
            case 22 -> 'm';
            case 23 -> 'n';
            case 24 -> 'o';
            case 25 -> 'p';
            case 26 -> 'q';
            case 27 -> 'r';
            case 28 -> 's';
            case 29 -> 't';
            case 30 -> 'u';
            case 31 -> 'v';
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
    }

    public static Path encode(Path parentDirectory, Location location) {
        World world = location.getWorld();
        long packed = BlockHistoryFileNames.getPackedPos(location);
        String encodedChunkFileName = new String(new char[]{BlockHistoryFileNames.base32encode((short)(packed >> 35 & 0x1FL)), BlockHistoryFileNames.base32encode((short)(packed >> 30 & 0x1FL)), BlockHistoryFileNames.base32encode((short)(packed >> 25 & 0x1FL)), BlockHistoryFileNames.base32encode((short)(packed >> 20 & 0x1FL)), BlockHistoryFileNames.base32encode((short)(packed >> 15 & 0x1FL)), BlockHistoryFileNames.base32encode((short)(packed >> 10 & 0x1FL)), BlockHistoryFileNames.base32encode((short)(packed >> 5 & 0x1FL)), BlockHistoryFileNames.base32encode((short)(packed & 0x1FL))});
        return Path.of(parentDirectory.toString(), world.getWorldFolder().getName(), encodedChunkFileName);
    }

    private static long getPackedPos(Location location) {
        int chunkX = HistoryManager.getChunkX(location);
        int chunkZ = HistoryManager.getChunkZ(location);
        long packed = 0L;
        packed |= (long)chunkX & 0x7FFFFL;
        if (chunkX < 0) {
            packed |= 0x80000L;
        }
        packed |= ((long)chunkZ & 0x7FFFFL) << 20;
        if (chunkZ < 0) {
            packed |= 0x8000000000L;
        }
        return packed;
    }
}

