/*
 * Decompiled with CFR 0.152.
 */
package de.shiewk.blockhistory.v3.util;

public final class UnitUtil {
    private UnitUtil() {
    }

    public static String formatTime(long totalMillis) {
        long millis = totalMillis % 1000L;
        long seconds = totalMillis / 1000L % 60L;
        long minutes = totalMillis / 60000L % 60L;
        long hours = totalMillis / 3600000L % 24L;
        long days = totalMillis / 86400000L;
        StringBuilder builder = new StringBuilder();
        if (days != 0L) {
            builder.append(days).append("d ");
        }
        if (hours != 0L) {
            builder.append(hours).append("h ");
        }
        if (minutes != 0L) {
            builder.append(minutes).append("m ");
        }
        if (seconds != 0L) {
            builder.append(seconds).append("s ");
        }
        if (builder.isEmpty() || millis != 0L) {
            builder.append(millis).append("ms");
        }
        return builder.toString().trim();
    }

    public static String formatDataSize(double bytes) {
        String[] suffixes = new String[]{"KiB", "MiB", "GiB"};
        String suffix = "bytes";
        int i = -1;
        while (bytes > 1024.0 && ++i < suffixes.length) {
            bytes /= 1024.0;
            suffix = suffixes[i];
        }
        return Math.floor(bytes * 10.0) / 10.0 + " " + suffix;
    }

    public static byte getBlockChunkLocation(int x) {
        byte b = (byte)(x % 16);
        if (b < 0) {
            b = (byte)(16 + b);
        }
        return b;
    }
}

