/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.tbcs;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.gitlab.srcmc.tbcs.api.TBCS;
import com.gitlab.srcmc.tbcs.api.utils.IdUtils;
import com.gitlab.srcmc.tbcs.commands.CommandsContext;
import com.gitlab.srcmc.tbcs.commands.TBCSCommands;
import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Unit;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModCommon {
    public static final String MOD_ID = "tbcs";
    public static final String MOD_NAME = "Cobblemon Trainer Battle Commands";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Cobblemon Trainer Battle Commands");
    public static Supplier<class_1657> player;

    public static void init() {
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (pb, rm, pf1, pf2, ex1, ex2) -> ((CompletableFuture)CompletableFuture.runAsync(TBCS.getInstance()::setReloadRequired).thenCompose(arg_0 -> ((class_3302.class_4045)pb).method_18352(arg_0))).thenAcceptAsync(v -> {}));
        TBCSCommands.register(new CommandsContext(){

            @Override
            public String getPrefix() {
                return ModCommon.MOD_ID;
            }

            @Override
            public int getWinCommandsPermission() {
                return TBCS.getInstance().getServerConfig().winCommandsPermission();
            }
        });
        ModCommon.registerEvents();
    }

    public static void initLocalPlayer(Supplier<class_1657> player) {
        ModCommon.player = player;
    }

    public static class_1657 localPlayer() {
        if (player == null) {
            throw new IllegalStateException("Local player not initialized, call ModCommon.initLocalPlayer on the client side");
        }
        return player.get();
    }

    static void registerEvents() {
        CommandRegistrationEvent.EVENT.register(ModCommon::onCommandRegistration);
        LifecycleEvent.SERVER_STARTING.register(ModCommon::onServerStarting);
        TickEvent.LevelTick.SERVER_PRE.register(ModCommon::onServerTick);
        PlayerEvent.PLAYER_JOIN.register(ModCommon::onPlayerJoin);
        PlayerEvent.PLAYER_QUIT.register(ModCommon::onPlayerQuit);
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, ModCommon::onBattleVictory);
    }

    static void onCommandRegistration(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 env) {
        TBCSCommands.registerCommands(dispatcher, context, env);
    }

    static void onServerStarting(MinecraftServer server) {
        TBCS.getInstance().setServer(server);
    }

    static void onServerTick(MinecraftServer server) {
        TBCS tbcs;
        if (server.method_3806() && (tbcs = TBCS.getInstance()).isReloadRequired()) {
            tbcs.loadTrainers();
        }
    }

    static void onPlayerJoin(class_3222 player) {
        TBCS.getInstance().getTrainerRegistry().registerPlayer(IdUtils.createTrainerId(MOD_ID, player.method_5477().getString(), IdUtils.TrainerIdType.PLAYER), player);
    }

    static void onPlayerQuit(class_3222 player) {
        TBCS.getInstance().getTrainerRegistry().unregisterById(IdUtils.createTrainerId(MOD_ID, player.method_5477().getString(), IdUtils.TrainerIdType.PLAYER));
    }

    public static Unit onBattleVictory(BattleVictoryEvent event) {
        return Unit.INSTANCE;
    }
}

