/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.tbcs.api;

import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.battle.BattleManager;
import com.gitlab.srcmc.rctapi.api.errors.RCTException;
import com.gitlab.srcmc.rctapi.api.events.Event;
import com.gitlab.srcmc.rctapi.api.events.EventContext;
import com.gitlab.srcmc.rctapi.api.events.EventListener;
import com.gitlab.srcmc.rctapi.api.events.EventType;
import com.gitlab.srcmc.rctapi.api.events.Events;
import com.gitlab.srcmc.rctapi.api.models.PokemonModel;
import com.gitlab.srcmc.rctapi.api.models.TrainerModel;
import com.gitlab.srcmc.rctapi.api.trainer.Trainer;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import com.gitlab.srcmc.rctapi.api.util.Locations;
import com.gitlab.srcmc.tbcs.ModCommon;
import com.gitlab.srcmc.tbcs.api.config.IClientConfig;
import com.gitlab.srcmc.tbcs.api.config.IServerConfig;
import com.gitlab.srcmc.tbcs.api.utils.IdUtils;
import com.gitlab.srcmc.tbcs.config.ClientConfig;
import com.gitlab.srcmc.tbcs.config.ServerConfig;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public final class TBCS {
    private Map<String, RegistryListener[]> registryListeners = new HashMap<String, RegistryListener[]>();
    private IClientConfig clientConfig;
    private IServerConfig serverConfig;
    private MinecraftServer server;
    private boolean reloadRequired;
    private static final RCTApi RCT = RCTApi.initInstance((String)"tbcs");
    private static final Gson GSON = RCT.gsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Supplier<TBCS> instanceSupplier = () -> {
        TBCS.init(new ClientConfig(), new ServerConfig());
        return instanceSupplier.get();
    };

    private TBCS(IClientConfig clientConfig, IServerConfig serverConfig) {
        this.clientConfig = clientConfig;
        this.serverConfig = serverConfig;
    }

    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public IServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServer(MinecraftServer server) {
        if (server != null && server != this.server) {
            BattleManager bm = RCT.getBattleManager();
            bm.getStates().stream().toList().forEach(bs -> bm.end(bs.getBattle().getBattleId(), true));
            RCT.getTrainerRegistry().init(server);
            this.reloadRequired = true;
        }
        this.server = server;
    }

    public TrainerRegistry getTrainerRegistry() {
        return RCT.getTrainerRegistry();
    }

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public void setReloadRequired() {
        this.reloadRequired = true;
    }

    public void loadTrainers() {
        int n;
        Object trainerId;
        Object fileId;
        if (this.server == null || !this.server.method_3806()) {
            ModCommon.LOG.info("Skipped trainer loading, server not running");
            return;
        }
        this.reloadRequired = false;
        TrainerRegistry trainerRegistry = RCT.getTrainerRegistry();
        HashMap prevTrainers = new HashMap();
        HashSet<String> dupes = new HashSet<String>();
        trainerRegistry.getIds().stream().forEach(tid -> {
            Trainer patt0$temp = trainerRegistry.getById(tid);
            if (patt0$temp instanceof TrainerNPC) {
                TrainerNPC tnpc = (TrainerNPC)patt0$temp;
                prevTrainers.put(tid, tnpc);
            }
        });
        this.registryListeners.values().forEach(ls -> {
            ls[0].unregister();
            ls[1].unregister();
        });
        this.registryListeners.clear();
        trainerRegistry.clearNPCs();
        for (String string : this.getServerConfig().trainerPaths()) {
            File trainerDir = Path.of(this.server.method_27050(class_5218.field_24188).toString(), string).toFile();
            File[] files = trainerDir.listFiles(f -> f.getName().toLowerCase().endsWith(".json"));
            if (files == null) continue;
            for (File trainerFile : files) {
                trainerId = fileId = IdUtils.createTrainerId("tbcs", TBCS.fileToId(trainerFile), IdUtils.TrainerIdType.NPC);
                n = 0;
                while (dupes.contains(trainerId)) {
                    trainerId = (String)fileId + "_" + ++n;
                }
                dupes.add((String)trainerId);
                try (BufferedReader rd = new BufferedReader(new FileReader(trainerFile));){
                    trainerRegistry.registerNPC((String)trainerId, TBCS.initLang((String)trainerId, (TrainerModel)GSON.fromJson((Reader)rd, TrainerModel.class)));
                }
                catch (RCTException errors) {
                    ModCommon.LOG.error("Model validation failure in: " + trainerFile.getPath());
                    errors.getErrors().forEach(error -> ModCommon.LOG.error(error.message));
                }
                catch (IOException e2) {
                    ModCommon.LOG.error("Failed to parse trainer", (Throwable)e2);
                }
            }
        }
        for (String string : this.getServerConfig().trainerMods()) {
            HashMap<String, String> originToDuped = new HashMap<String, String>();
            RCTApi otherRct = RCTApi.getInstance((String)string);
            TrainerRegistry otherReg = otherRct.getTrainerRegistry();
            for (String otherId : otherReg.getIds()) {
                fileId = otherReg.getById(otherId);
                if (!(fileId instanceof TrainerNPC)) continue;
                TrainerNPC otherTrainer = (TrainerNPC)fileId;
                String trainerModId = IdUtils.createTrainerId(string, otherId, IdUtils.TrainerIdType.NPC);
                trainerId = trainerModId;
                n = 0;
                while (dupes.contains(trainerId)) {
                    trainerId = trainerModId + "_" + ++n;
                }
                trainerRegistry.registerNPC((String)trainerId, new TrainerNPC(otherTrainer));
                originToDuped.put(otherId, (String)trainerId);
            }
            RegistryListener[] listeners = new RegistryListener[]{new RegistryListener(string, dupes, originToDuped, Events.TRAINER_REGISTRED, otherRct.getEventContext()), new RegistryListener(string, dupes, originToDuped, Events.TRAINER_UNREGISTRED, otherRct.getEventContext())};
            this.registryListeners.put(string, listeners);
            otherRct.getEventContext().register(Events.TRAINER_REGISTRED, (EventListener)listeners[0]);
            otherRct.getEventContext().register(Events.TRAINER_UNREGISTRED, (EventListener)listeners[1]);
        }
        prevTrainers.entrySet().forEach(e -> {
            Trainer patt0$temp;
            class_1309 entt = ((TrainerNPC)e.getValue()).getEntity();
            if (entt.method_5805() && (patt0$temp = trainerRegistry.getById((String)e.getKey())) instanceof TrainerNPC) {
                TrainerNPC tnpc = (TrainerNPC)patt0$temp;
                tnpc.setEntity(entt);
            }
        });
        ModCommon.LOG.info("Registered " + trainerRegistry.getIds().size() + " trainers");
    }

    private static final String LANG_TRAINER_NAME(String trainerId) {
        return String.format("trainer.tbcs.%s.name", trainerId);
    }

    private static final String LANG_POKEMON_NICKNAME(String trainerId, int position) {
        return String.format("pokemon.tbcs.%s.%d.name", trainerId, position);
    }

    private static String fileToId(File file) {
        String name = file.getName().toLowerCase().trim();
        int i = name.lastIndexOf(46);
        return i < 0 ? name : name.substring(0, i);
    }

    private static TrainerModel initLang(String trainerId, TrainerModel trainer) {
        trainerId = Locations.withoutNamespace((String)trainerId);
        int i = 0;
        if (trainer.getName().getTranslatable() == null) {
            trainer.getName().setTranslatable(TBCS.LANG_TRAINER_NAME(trainerId));
        }
        for (PokemonModel p : trainer.getTeam()) {
            if (p.getNickname().getTranslatable() == null) {
                p.getNickname().setTranslatable(TBCS.LANG_POKEMON_NICKNAME(trainerId, i));
            }
            ++i;
        }
        return trainer;
    }

    public static void init(IClientConfig clientConfig, IServerConfig serverConfig) {
        TBCS instance = new TBCS(clientConfig, serverConfig);
        instanceSupplier = () -> instance;
    }

    public static TBCS getInstance() {
        return instanceSupplier.get();
    }

    private static class RegistryListener
    implements EventListener<Map.Entry<String, Trainer>> {
        private EventListener<Map.Entry<String, Trainer>> handler;
        private Map<String, String> originToDuped;
        private EventContext eventContext;
        private HashSet<String> dupes;
        private String modId;

        public RegistryListener(String modId, HashSet<String> dupes, Map<String, String> originToDuped, EventType<?> eventType, EventContext eventContext) {
            this.modId = modId;
            this.dupes = dupes;
            this.originToDuped = originToDuped;
            this.eventContext = eventContext;
            this.handler = eventType == Events.TRAINER_REGISTRED ? this::handleRegistered : (eventType == Events.TRAINER_UNREGISTRED ? this::handleUnregistered : e -> {});
        }

        public void notify(Event<Map.Entry<String, Trainer>> event) {
            this.handler.notify(event);
        }

        public void unregister() {
            this.eventContext.unregister((EventListener)this);
        }

        private void handleRegistered(Event<Map.Entry<String, Trainer>> event) {
            Object v = ((Map.Entry)event.getValue()).getValue();
            if (v instanceof TrainerNPC) {
                TrainerNPC otherTrainer = (TrainerNPC)v;
                String otherId = (String)((Map.Entry)event.getValue()).getKey();
                otherId = IdUtils.createTrainerId(this.modId, (String)((Map.Entry)event.getValue()).getKey(), IdUtils.TrainerIdType.NPC);
                Object trainerId = otherId;
                int n = 0;
                while (this.dupes.contains(trainerId)) {
                    trainerId = otherId + "_" + ++n;
                }
                RCT.getTrainerRegistry().registerNPC((String)trainerId, new TrainerNPC(otherTrainer));
                this.originToDuped.put((String)((Map.Entry)event.getValue()).getKey(), (String)trainerId);
            }
        }

        private void handleUnregistered(Event<Map.Entry<String, Trainer>> event) {
            String trainerId;
            if (((Map.Entry)event.getValue()).getValue() instanceof TrainerNPC && (trainerId = this.originToDuped.get(((Map.Entry)event.getValue()).getKey())) != null) {
                RCT.getTrainerRegistry().unregisterById(trainerId);
            }
        }
    }
}

