/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.tbcs.config;

import com.gitlab.srcmc.tbcs.api.config.IServerConfig;
import java.util.Collection;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig
implements IServerConfig {
    private static final String SEPARATOR = "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501";
    private final ModConfigSpec.ConfigValue<List<? extends String>> trainerPathsValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> trainerModsValue;
    private final ModConfigSpec.ConfigValue<Integer> winCommandsPermissionValue;
    private List<? extends String> trainerPathsCached;
    private List<? extends String> trainerModsCached;
    private int winCommandsPermissionCached;
    private final ModConfigSpec spec;

    public ServerConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Trainers");
        this.trainerPathsValue = builder.comment(new String[]{SEPARATOR, "List of paths, relative to the world directory, to search for trainer\njson files when (re)loading a world.\n\nDefault: [\"trainers\", \"../trainers\", \"../../trainers\"]"}).defineList("trainerPaths", IServerConfig.super.trainerPaths(), null, e -> true);
        this.trainerModsValue = builder.comment(new String[]{SEPARATOR, "List of mod ids from mods that also rely on RCTApi to define trainers.\nCopies of trainers from the listed mods will also be registered to TBCS.\n\nDefault: [\"rctmod\"]"}).defineList("trainerMods", IServerConfig.super.trainerMods(), null, e -> true);
        builder.pop();
        builder.push("Commands");
        this.winCommandsPermissionValue = builder.comment(new String[]{SEPARATOR, "Permission level of win commands.\n\nDefault: 2"}).defineInRange("winCommandsPermission", IServerConfig.super.winCommandsPermission(), 1, 4);
        this.spec = builder.build();
    }

    @Override
    public void reload() {
        this.updateChache();
    }

    private void updateChache() {
        this.trainerPathsCached = List.copyOf((Collection)this.trainerPathsValue.get());
        this.trainerModsCached = List.copyOf((Collection)this.trainerModsValue.get());
        this.winCommandsPermissionCached = (Integer)this.winCommandsPermissionValue.get();
    }

    @Override
    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public List<? extends String> trainerPaths() {
        return this.trainerPathsCached;
    }

    @Override
    public List<? extends String> trainerMods() {
        return this.trainerModsCached;
    }

    @Override
    public int winCommandsPermission() {
        return this.winCommandsPermissionCached;
    }
}

