/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.heartstone.HeartstoneClient;
import net.mehvahdjukaar.heartstone.HeartstoneItem;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.SimpleMapMarker;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1745;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_22;
import net.minecraft.class_2400;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9209;
import net.minecraft.class_9331;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Heartstone {
    public static final String MOD_ID = "heartstone";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean CURIO = PlatHelper.isModLoaded((String)"curio");
    public static final boolean TRINKETS = PlatHelper.isModLoaded((String)"trinkets");
    public static final Supplier<class_3414> HEARTSTONE_SOUND = RegHelper.registerSound((class_2960)Heartstone.res("item.heartstone"));
    public static final Supplier<class_2400> HEARTSTONE_PARTICLE = RegHelper.registerParticle((class_2960)Heartstone.res("heartstone_trail"));
    public static final Supplier<class_2400> HEARTSTONE_PARTICLE_EMITTER = RegHelper.registerParticle((class_2960)Heartstone.res("heartstone_emitter"));
    public static final Supplier<class_9331<Long>> HEARTSTONE_ID = RegHelper.registerDataComponent((class_2960)Heartstone.res("heartstone_id"), () -> class_9331.method_57873().method_57881((Codec)Codec.LONG).method_57882(class_9135.field_48551).method_57880());
    public static final Supplier<class_9331<class_3902>> CRACKED = RegHelper.registerDataComponent((class_2960)Heartstone.res("cracked"), () -> class_9331.method_57873().method_57881(class_3902.field_51563).method_57882(class_9139.method_56431((Object)class_3902.field_17274)).method_57880());
    public static final Supplier<class_1792> HEARTSTONE_ITEM = RegHelper.registerItem((class_2960)Heartstone.res("heartstone"), HeartstoneItem::new);
    public static final class_6862<class_2582> HEART_TAG = class_6862.method_40092((class_5321)class_7924.field_41252, (class_2960)Heartstone.res("pattern_item/heart"));
    public static final Supplier<class_1792> HEART_PATTERN_ITEM = RegHelper.registerItem((class_2960)Heartstone.res("heart_banner_pattern"), () -> new class_1745(HEART_TAG, new class_1792.class_1793().method_7894(class_1814.field_8903)));
    public static final Supplier<Integer> HIGHLIGHT_COLOR;
    public static final Supplier<Boolean> HIGHLIGHT;
    public static final Supplier<Integer> HIGHLIGHT_DISTANCE;
    public static final Supplier<Integer> HIGHLIGHT_DURATION;
    public static final HolderReference<MLMapDecorationType<?, ?>> HEARTSTONE_MARKER;

    public static class_2960 res(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        NetworkHandler.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            HeartstoneClient.init();
            ClientHelper.registerOptionalTexturePack((class_2960)Heartstone.res("heart_particles"), (boolean)false);
        }
        RegHelper.addItemsToTabsRegistration(Heartstone::addItemsToTabs);
        MapDataRegistry.addDynamicServerMarkersEvent(Heartstone::getDynamicDecorations);
        MoonlightEventsHelper.addListener(Heartstone::onPlayerDeath, IDropItemOnDeathEvent.class);
    }

    private static Set<MLMapMarker<?>> getDynamicDecorations(class_1657 player, class_9209 mapId, class_22 data) {
        List<class_1799> list = HeartstoneItem.getAllHeartstones(player);
        ArrayList<class_1657> visiblePlayers = new ArrayList<class_1657>();
        Iterator iterator = new ArrayList(player.method_37908().method_8503().method_3760().method_14571()).iterator();
        for (class_1799 i : list) {
            boolean found = false;
            while (iterator.hasNext() && !found) {
                class_1657 targetPlayer = (class_1657)iterator.next();
                HeartstoneItem cfr_ignored_0 = (HeartstoneItem)i.method_7909();
                if (!HeartstoneItem.arePlayersBound(player, i, targetPlayer, true)) continue;
                visiblePlayers.add(targetPlayer);
                iterator.remove();
                found = true;
            }
        }
        HashSet markers = new HashSet();
        for (class_1657 p : visiblePlayers) {
            SimpleMapMarker marker = new SimpleMapMarker(HEARTSTONE_MARKER.getHolder(player.method_37908()), p.method_23312(), Float.valueOf(p.method_36454()), Optional.ofNullable(p.method_5476()));
            markers.add((MLMapMarker<?>)marker);
        }
        return markers;
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
        event.addAfter(class_7706.field_41062, i -> i.method_31574(class_1802.field_49816), new class_1935[]{(class_1935)HEART_PATTERN_ITEM.get()});
        event.addBefore(class_7706.field_41060, i -> i.method_31574(class_1802.field_8251), new class_1935[]{(class_1935)HEARTSTONE_ITEM.get()});
    }

    public static void onPlayerDeath(IDropItemOnDeathEvent event) {
        class_1657 p = event.getPlayer();
        if (event.isBeforeDrop()) {
            List<class_1799> list = HeartstoneItem.getAllHeartstones(p);
            for (class_1799 h : list) {
                class_1657 target = HeartstoneItem.getBoundPlayer(p, h, false);
                if (target == null) continue;
                Long id = HeartstoneItem.getHeartstoneId(h);
                List<class_1799> targetList = HeartstoneItem.getAllHeartstones(target);
                for (class_1799 th : targetList) {
                    if (!HeartstoneItem.hasMatchingId(id, th)) continue;
                    HeartstoneItem.crack(th, (class_1297)target);
                }
            }
        }
    }

    static {
        ConfigBuilder config = ConfigBuilder.create((class_2960)Heartstone.res("client"), (ConfigType)ConfigType.CLIENT);
        config.push("highlight");
        HIGHLIGHT_COLOR = config.comment("Highlight color").defineColor("color", 16738511);
        HIGHLIGHT = config.define("enabled", true);
        HIGHLIGHT_DISTANCE = config.comment("Distance at which the player highlight will take effect").define("distance", 20, 0, 10000);
        HIGHLIGHT_DURATION = config.define("duration", 100, 0, 10000);
        config.pop();
        config.build();
        HEARTSTONE_MARKER = HolderReference.of((class_2960)Heartstone.res(MOD_ID), (class_5321)MapDataRegistry.REGISTRY_KEY);
    }
}

