/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.heartstone.HeartstoneClient;
import net.mehvahdjukaar.heartstone.HeartstoneItem;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.SimpleMapMarker;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Heartstone {
    public static final String MOD_ID = "heartstone";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean CURIO = PlatHelper.isModLoaded((String)"curio");
    public static final boolean TRINKETS = PlatHelper.isModLoaded((String)"trinkets");
    public static final Supplier<SoundEvent> HEARTSTONE_SOUND = RegHelper.registerSound((ResourceLocation)Heartstone.res("item.heartstone"));
    public static final Supplier<SimpleParticleType> HEARTSTONE_PARTICLE = RegHelper.registerParticle((ResourceLocation)Heartstone.res("heartstone_trail"));
    public static final Supplier<SimpleParticleType> HEARTSTONE_PARTICLE_EMITTER = RegHelper.registerParticle((ResourceLocation)Heartstone.res("heartstone_emitter"));
    public static final Supplier<DataComponentType<Long>> HEARTSTONE_ID = RegHelper.registerDataComponent((ResourceLocation)Heartstone.res("heartstone_id"), () -> DataComponentType.builder().persistent((Codec)Codec.LONG).networkSynchronized(ByteBufCodecs.VAR_LONG).build());
    public static final Supplier<DataComponentType<Unit>> CRACKED = RegHelper.registerDataComponent((ResourceLocation)Heartstone.res("cracked"), () -> DataComponentType.builder().persistent(Unit.CODEC).networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)).build());
    public static final Supplier<Item> HEARTSTONE_ITEM = RegHelper.registerItem((ResourceLocation)Heartstone.res("heartstone"), HeartstoneItem::new);
    public static final TagKey<BannerPattern> HEART_TAG = TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)Heartstone.res("pattern_item/heart"));
    public static final Supplier<Item> HEART_PATTERN_ITEM = RegHelper.registerItem((ResourceLocation)Heartstone.res("heart_banner_pattern"), () -> new BannerPatternItem(HEART_TAG, new Item.Properties().rarity(Rarity.RARE)));
    public static final Supplier<Integer> HIGHLIGHT_COLOR;
    public static final Supplier<Boolean> HIGHLIGHT;
    public static final Supplier<Integer> HIGHLIGHT_DISTANCE;
    public static final Supplier<Integer> HIGHLIGHT_DURATION;
    public static final HolderReference<MLMapDecorationType<?, ?>> HEARTSTONE_MARKER;

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        NetworkHandler.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            HeartstoneClient.init();
            ClientHelper.registerOptionalTexturePack((ResourceLocation)Heartstone.res("heart_particles"), (boolean)false);
        }
        RegHelper.addItemsToTabsRegistration(Heartstone::addItemsToTabs);
        MapDataRegistry.addDynamicServerMarkersEvent(Heartstone::getDynamicDecorations);
        MoonlightEventsHelper.addListener(Heartstone::onPlayerDeath, IDropItemOnDeathEvent.class);
    }

    private static Set<MLMapMarker<?>> getDynamicDecorations(Player player, MapId mapId, MapItemSavedData data) {
        List<ItemStack> list = HeartstoneItem.getAllHeartstones(player);
        ArrayList<Player> visiblePlayers = new ArrayList<Player>();
        Iterator iterator = new ArrayList(player.level().getServer().getPlayerList().getPlayers()).iterator();
        for (ItemStack i : list) {
            boolean found = false;
            while (iterator.hasNext() && !found) {
                Player targetPlayer = (Player)iterator.next();
                HeartstoneItem cfr_ignored_0 = (HeartstoneItem)i.getItem();
                if (!HeartstoneItem.arePlayersBound(player, i, targetPlayer, true)) continue;
                visiblePlayers.add(targetPlayer);
                iterator.remove();
                found = true;
            }
        }
        HashSet markers = new HashSet();
        for (Player p : visiblePlayers) {
            SimpleMapMarker marker = new SimpleMapMarker(HEARTSTONE_MARKER.getHolder(player.level()), p.getOnPos(), Float.valueOf(p.getYRot()), Optional.ofNullable(p.getDisplayName()));
            markers.add((MLMapMarker<?>)marker);
        }
        return markers;
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
        event.addAfter(CreativeModeTabs.INGREDIENTS, i -> i.is(Items.GUSTER_BANNER_PATTERN), new ItemLike[]{(ItemLike)HEART_PATTERN_ITEM.get()});
        event.addBefore(CreativeModeTabs.TOOLS_AND_UTILITIES, i -> i.is(Items.COMPASS), new ItemLike[]{(ItemLike)HEARTSTONE_ITEM.get()});
    }

    public static void onPlayerDeath(IDropItemOnDeathEvent event) {
        Player p = event.getPlayer();
        if (event.isBeforeDrop()) {
            List<ItemStack> list = HeartstoneItem.getAllHeartstones(p);
            for (ItemStack h : list) {
                Player target = HeartstoneItem.getBoundPlayer(p, h, false);
                if (target == null) continue;
                Long id = HeartstoneItem.getHeartstoneId(h);
                List<ItemStack> targetList = HeartstoneItem.getAllHeartstones(target);
                for (ItemStack th : targetList) {
                    if (!HeartstoneItem.hasMatchingId(id, th)) continue;
                    HeartstoneItem.crack(th, (Entity)target);
                }
            }
        }
    }

    static {
        ConfigBuilder config = ConfigBuilder.create((ResourceLocation)Heartstone.res("client"), (ConfigType)ConfigType.CLIENT);
        config.push("highlight");
        HIGHLIGHT_COLOR = config.comment("Highlight color").defineColor("color", 16738511);
        HIGHLIGHT = config.define("enabled", true);
        HIGHLIGHT_DISTANCE = config.comment("Distance at which the player highlight will take effect").define("distance", 20, 0, 10000);
        HIGHLIGHT_DURATION = config.define("duration", 100, 0, 10000);
        config.pop();
        config.build();
        HEARTSTONE_MARKER = HolderReference.of((ResourceLocation)Heartstone.res(MOD_ID), (ResourceKey)MapDataRegistry.REGISTRY_KEY);
    }
}

