/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.lang.ref.WeakReference;
import net.mehvahdjukaar.heartstone.Heartstone;
import net.mehvahdjukaar.heartstone.HeartstoneItem;
import net.mehvahdjukaar.heartstone.HeartstoneParticle;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HeartstoneClient {
    private static WeakReference<Player> glowPlayer;
    private static int cooldown;

    public static void init() {
        ClientHelper.addParticleRegistration(HeartstoneClient::registerParticles);
        ClientHelper.addClientSetup(() -> ItemProperties.register((Item)Heartstone.HEARTSTONE_ITEM.get(), (ResourceLocation)Heartstone.res("cracked"), (itemStack, clientLevel, livingEntity, i) -> HeartstoneItem.isCracked(itemStack) ? 1.0f : 0.0f));
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((ParticleType)Heartstone.HEARTSTONE_PARTICLE.get(), HeartstoneParticle.Factory::new);
        event.register((ParticleType)Heartstone.HEARTSTONE_PARTICLE_EMITTER.get(), HeartstoneParticle.EmitterFactory::new);
    }

    public static void spawnParticle(NetworkHandler.ClientBoundSpawnHeartstoneParticlePacket message) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Level level = player.level();
        int d = Heartstone.HIGHLIGHT_DISTANCE.get();
        if (Heartstone.HIGHLIGHT.get().booleanValue() && message.from().equals(player.getUUID()) && message.dist().lengthSqr() < (double)(d * d)) {
            HeartstoneClient.highlightPlayer(level.getPlayerByUUID(message.target()));
        }
        Vec3 dist = message.dist();
        Vec3 pos = message.pos();
        level.addParticle((ParticleOptions)Heartstone.HEARTSTONE_PARTICLE_EMITTER.get(), pos.x, pos.y, pos.z, dist.x, dist.y, dist.z);
    }

    public static void onClientTick() {
        if (cooldown != 0 && --cooldown == 0) {
            glowPlayer = null;
        }
    }

    public static void highlightPlayer(Player player) {
        glowPlayer = new WeakReference<Player>(player);
        cooldown = Heartstone.HIGHLIGHT_DURATION.get();
    }

    public static boolean isPlayerHighlighted(Entity player) {
        if (glowPlayer != null) {
            return glowPlayer.get() == player;
        }
        return false;
    }
}

