/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.heartstone.Heartstone;
import net.mehvahdjukaar.heartstone.HeartstoneData;
import net.mehvahdjukaar.heartstone.NetworkHandler;
import net.mehvahdjukaar.heartstone.compat.CurioCompat;
import net.mehvahdjukaar.heartstone.compat.TrinketsCompat;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HeartstoneItem
extends Item {
    public HeartstoneItem() {
        super(new Item.Properties().rarity(Rarity.RARE).stacksTo(2));
    }

    public boolean isFoil(ItemStack pStack) {
        return HeartstoneItem.getHeartstoneId(pStack) != null;
    }

    @Nullable
    public static Long getHeartstoneId(ItemStack stack) {
        return (Long)stack.getOrDefault(Heartstone.HEARTSTONE_ID.get(), null);
    }

    public static boolean isCracked(ItemStack stack) {
        return stack.has(Heartstone.CRACKED.get());
    }

    public static void crack(ItemStack stack, Entity entity) {
        stack.set(Heartstone.CRACKED.get(), (Object)Unit.INSTANCE);
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (p.getMainHandItem() == stack) {
                p.onEquippedItemBroken(stack.getItem(), EquipmentSlot.MAINHAND);
            }
            if (p.getOffhandItem() == stack) {
                p.onEquippedItemBroken(stack.getItem(), EquipmentSlot.OFFHAND);
            }
        }
        entity.playSound(SoundEvents.AMETHYST_CLUSTER_BREAK, 0.6f, 1.3f);
        entity.playSound(SoundEvents.VEX_HURT, 1.3f, 0.7f);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player p;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (HeartstoneItem.isCracked(stack) && (level.getGameTime() + 1L) % 40L == 0L && entity instanceof Player && HeartstoneItem.getBoundPlayer(p = (Player)entity, stack, false) != null) {
            stack.remove(Heartstone.CRACKED.get());
            entity.playSound(SoundEvents.AMETHYST_BLOCK_RESONATE, 0.8f, 0.7f);
            entity.playSound(SoundEvents.ALLAY_ITEM_TAKEN, 1.1f, 1.2f);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player player, InteractionHand pHand) {
        ItemStack itemstack = player.getItemInHand(pHand);
        if (pLevel.isClientSide) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        Player otherPlayer = HeartstoneItem.getBoundPlayer(player, itemstack, true);
        if (otherPlayer != null) {
            NetworkHandler.sendHeartstoneParticles(player, otherPlayer);
        } else {
            pLevel.playSound(null, (Entity)player, SoundEvents.AMETHYST_BLOCK_FALL, player.getSoundSource(), 0.6f, 0.7f);
        }
        player.getCooldowns().addCooldown((Item)this, 60);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    @Nullable
    public static Player getBoundPlayer(Player player, ItemStack itemstack, boolean sameDim) {
        Level level;
        Long id = HeartstoneItem.getHeartstoneId(itemstack);
        if (id != null && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PlayerList players = serverLevel.getServer().getPlayerList();
            for (Player targetPlayer : players.getPlayers()) {
                if (!HeartstoneItem.arePlayersBound(player, itemstack, targetPlayer, sameDim)) continue;
                return targetPlayer;
            }
        }
        return null;
    }

    public static List<ItemStack> getAllHeartstones(Player player) {
        ItemStack s;
        ArrayList<ItemStack> found = new ArrayList<ItemStack>();
        player.getInventory().items.stream().filter(i -> i.getItem() instanceof HeartstoneItem).forEach(found::add);
        if (Heartstone.TRINKETS && !(s = TrinketsCompat.getHeartstone(player)).isEmpty()) {
            found.add(s);
        }
        if (Heartstone.CURIO && !(s = CurioCompat.getHeartstone(player)).isEmpty()) {
            found.add(s);
        }
        return found;
    }

    public static boolean arePlayersBound(Player pPlayer, ItemStack original, Player target, boolean sameDimension) {
        if (sameDimension && target.level().dimension() != pPlayer.level().dimension()) {
            return false;
        }
        if (target != pPlayer) {
            ItemStack s;
            Long id = HeartstoneItem.getHeartstoneId(original);
            if (id == null) {
                return false;
            }
            Inventory inv = target.getInventory();
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                ItemStack s2 = inv.getItem(i);
                if (!HeartstoneItem.hasMatchingId(id, s2)) continue;
                return true;
            }
            if (Heartstone.TRINKETS && !(s = TrinketsCompat.getHeartstone(target)).isEmpty() && HeartstoneItem.hasMatchingId(id, s)) {
                return true;
            }
            if (Heartstone.CURIO) {
                ItemStack s3 = CurioCompat.getHeartstone(target);
                return !s3.isEmpty() && HeartstoneItem.hasMatchingId(id, s3);
            }
        }
        return false;
    }

    public static boolean hasMatchingId(Long id, ItemStack s) {
        if (s.getItem() instanceof HeartstoneItem) {
            Long other = HeartstoneItem.getHeartstoneId(s);
            return other != null && other.equals(id);
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Long id = HeartstoneItem.getHeartstoneId(stack);
        if (id != null) {
            tooltipComponents.add((Component)Component.translatable((String)"message.heartstone.id", (Object[])new Object[]{id}));
        }
        if (HeartstoneItem.isCracked(stack)) {
            tooltipComponents.add((Component)Component.translatable((String)"message.heartstone.cracked"));
        }
    }

    public void onCraftedBy(ItemStack pStack, Level pLevel, Player pPlayer) {
        super.onCraftedBy(pStack, pLevel, pPlayer);
        if (HeartstoneItem.getHeartstoneId(pStack) == null && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            pStack.set(Heartstone.HEARTSTONE_ID.get(), (Object)HeartstoneData.getNewId(serverLevel));
        }
    }
}

