/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import net.mehvahdjukaar.heartstone.Heartstone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HeartstoneParticle
extends TextureSheetParticle {
    private HeartstoneParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet sprites) {
        super(world, x, y, z);
        this.pickSprite(sprites);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.setSize(0.01f, 0.01f);
        this.quadSize = 0.5f;
        this.gravity = 0.0f;
        this.hasPhysics = false;
        this.lifetime = 20;
        this.setColor(1.0f, 1.0f, 1.0f);
    }

    public void move(double pX, double pY, double pZ) {
        this.setBoundingBox(this.getBoundingBox().move(pX, pY, pZ));
        this.setLocationFromBoundingbox();
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        float x = (float)this.age / (float)this.lifetime;
        this.alpha = 1.0f - x * x;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double index, double a, double b) {
            HeartstoneParticle particle = new HeartstoneParticle(worldIn, x, y, z, 0.0, 0.0, 0.0, this.sprite);
            int i = (int)Mth.clamp((double)index, (double)0.0, (double)2.0);
            particle.setSprite(this.sprite.get(i, 2));
            return particle;
        }
    }

    public static class EmitterFactory
    implements ParticleProvider<SimpleParticleType> {
        public EmitterFactory(SpriteSet spriteSet) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new Emitter(level, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public static class Emitter
    extends NoRenderParticle {
        private final int type;

        public Emitter(ClientLevel world, double x, double y, double z, double dx, double dy, double dz) {
            super(world, x, y, z, 0.0, 0.0, 0.0);
            Vec3 v = new Vec3(dx, dy, dz);
            double dist = v.lengthSqr();
            this.type = dist >= 1.0E8 ? 2 : (dist >= 1000000.0 ? 1 : 0);
            v = v.normalize();
            this.xd = v.x;
            this.yd = v.y;
            this.zd = v.z;
            LocalPlayer player = Minecraft.getInstance().player;
            world.playSound((Player)player, (Entity)player, Heartstone.HEARTSTONE_SOUND.get(), player.getSoundSource(), 1.0f, 1.25f - (float)this.type * 0.25f);
            world.playSound((Player)player, (Entity)player, SoundEvents.AMETHYST_BLOCK_RESONATE, player.getSoundSource(), 1.0f, 1.0f);
        }

        public void tick() {
            ++this.age;
            this.level.addParticle((ParticleOptions)Heartstone.HEARTSTONE_PARTICLE.get(), this.x + (double)this.age * 1.2 * this.xd, this.y + (double)this.age * 1.2 * this.yd, this.z + (double)this.age * 1.2 * this.zd, (double)this.type, 0.0, 0.0);
            if (this.age >= 15) {
                this.remove();
            }
        }
    }
}

