/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.heartstone;

import java.util.UUID;
import net.mehvahdjukaar.heartstone.Heartstone;
import net.mehvahdjukaar.heartstone.HeartstoneClient;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class NetworkHandler {
    public static void init() {
        NetworkHelper.addNetworkRegistration(NetworkHandler::registerMessages, (int)1);
    }

    private static void registerMessages(NetworkHelper.RegisterMessagesEvent event) {
        event.registerClientBound(ClientBoundSpawnHeartstoneParticlePacket.CODEC);
    }

    public static void sendHeartstoneParticles(Player player, Player other) {
        Vec3 pos = player.getEyePosition();
        NetworkHelper.sendToAllClientPlayersTrackingEntityAndSelf((Entity)player, (Message)new ClientBoundSpawnHeartstoneParticlePacket(pos, other.getEyePosition().subtract(pos), player.getUUID(), other.getUUID()));
    }

    public record ClientBoundSpawnHeartstoneParticlePacket(Vec3 pos, Vec3 dist, UUID from, UUID target) implements Message
    {
        private static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundSpawnHeartstoneParticlePacket> CODEC = Message.makeType((ResourceLocation)Heartstone.res("spawn_heartstone_particle"), ClientBoundSpawnHeartstoneParticlePacket::new);

        public ClientBoundSpawnHeartstoneParticlePacket(FriendlyByteBuf buf) {
            this(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readUUID(), buf.readUUID());
        }

        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeDouble(this.pos.x);
            buf.writeDouble(this.pos.y);
            buf.writeDouble(this.pos.z);
            buf.writeDouble(this.dist.x);
            buf.writeDouble(this.dist.y);
            buf.writeDouble(this.dist.z);
            buf.writeUUID(this.from);
            buf.writeUUID(this.target);
        }

        public void handle(Message.Context context) {
            HeartstoneClient.spawnParticle(this);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CODEC.type();
        }
    }
}

