/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.morecollectables.entity;

import net.mcreator.morecollectables.init.MorecollectablesModBlocks;
import net.mcreator.morecollectables.init.MorecollectablesModEntities;
import net.mcreator.morecollectables.init.MorecollectablesModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class WomanCivilianEntity
extends PathfinderMob {
    public WomanCivilianEntity(EntityType<WomanCivilianEntity> type, Level world) {
        super(type, world);
        this.xpReward = 10;
        this.setNoAi(false);
        this.setCustomName((Component)Component.literal((String)"Civilian"));
        this.setCustomNameVisible(true);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.WOODEN_PICKAXE));
    }

    protected void registerGoals() {
        super.registerGoals();
        this.getNavigation().getNodeEvaluator().setCanOpenDoors(true);
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(7, (Goal)new OpenDoorGoal((Mob)this, false));
        this.goalSelector.addGoal(8, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.goalSelector.addGoal(9, (Goal)new RemoveBlockGoal(Blocks.OAK_LOG, (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(10, (Goal)new RemoveBlockGoal(Blocks.GRASS_BLOCK, (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(11, (Goal)new RemoveBlockGoal(Blocks.TORCH, (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(12, (Goal)new RemoveBlockGoal(Blocks.WALL_TORCH, (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(13, (Goal)new RemoveBlockGoal((Block)MorecollectablesModBlocks.FLESH.get(), (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(14, (Goal)new RemoveBlockGoal((Block)MorecollectablesModBlocks.WET_GRASS.get(), (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(15, (Goal)new RemoveBlockGoal((Block)MorecollectablesModBlocks.MAPLE_LEAVES.get(), (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(16, (Goal)new RemoveBlockGoal((Block)MorecollectablesModBlocks.SUCKED_OUT_MAPLE_LOG.get(), (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(17, (Goal)new RemoveBlockGoal((Block)MorecollectablesModBlocks.MAPLE_FENCE.get(), (PathfinderMob)this, 1.0, 3));
        this.goalSelector.addGoal(18, (Goal)new RemoveBlockGoal(Blocks.BEDROCK, (PathfinderMob)this, 1.0, 3));
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)MorecollectablesModItems.HEART.get()));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)MorecollectablesModEntities.WOMAN_CIVILIAN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

